#include "TSNumKeypad.h"

TSNumKeypad::TSNumKeypad() : mSerial(0), virtualGroveConnector()
{
}

void TSNumKeypad::init(byte pin)
{
  if (!mSerial)
  {
    mSerial = new SoftwareSerial(pin, pin + 1);
  }
  mSerial->begin(9600);
}

char TSNumKeypad::getValue()
{
    if(!mSerial->available())
    {
        return '\0';
    }
    else
    {
        byte data = mSerial->read();
        switch(data) {
            case 0xE1 :
                return '1';
                break;
            case 0xE2 :
                return '2';
                break;
            case 0xE3 :
                return '3';
                break;
            case 0xE4 :
                return '4';
                break;
            case 0xE5 :
                return '5';
                break;
            case 0xE6 :
                return '6';
                break;
            case 0xE7 :
                return '7';
                break;
            case 0xE8 :
                return '8';
                break;
            case 0xE9 :
                return '9';
                break;
            case 0xEA :
                return '*';
                break;
            case 0xEB :
                return '0';
                break;
            case 0xEC :
                return '#';
                break;
        }
    }
}