#ifndef snake_h
#define snake_h

#define SNAKE_MAX_SIZE MATRIX_SIZE * MATRIX_SIZE
#define SNAKE_START_SIZE 3

#define SNAKE_DIRECTION_LEFT 0
#define SNAKE_DIRECTION_UP 1
#define SNAKE_DIRECTION_DOWN 2
#define SNAKE_DIRECTION_RIGHT 3

#define SNAKE_STATUS_WAITING -2
#define SNAKE_STATUS_PLAYING 0
#define SNAKE_STATUS_LOOSE -1
#define SNAKE_STATUS_WIN 1

#include <Arduino.h>
#include "LedMatrix.h"
#include "AsciiDisplay.h"

class Snake {
    public:
        Snake(LedMatrix* matrix);
        void initGame();
        void loop();

        /* the functions the student will use */
        void restart();
        void changeDirection(int direction);
        bool isInWall();
        bool isInQueue();
        bool isEating();
        void grow();
        void newFood();
        void accelerate();
        void slowDown();
        int getSize();
        void loose();
        void win();
        void dump();

    private:
        LedMatrix* matrix;

        /*
           [0] = head ; [n] = body ; [max] = queue
           [x][0] = line ; [x][1] = column
           -1 for line and column mean not used
           -2 for line and column mean new queue to init
        */
        int snake[SNAKE_MAX_SIZE][2];
        int size;
        /* the position of the food */
        int food[2];

        int nextDirection = SNAKE_DIRECTION_LEFT;
        int direction = SNAKE_DIRECTION_LEFT;
        int moveLength_ms; /* 500ms per movement */
        int prevMove;

        int gameStatus = SNAKE_STATUS_WAITING;

        /* indicates if the position is a valid position for the currentsnake body */
        bool isSnake(int position);
        void moveSnake();
};

#endif
