#ifndef number_display_h
#define number_display_h

#include <Arduino.h>
#include "digit-4x8.h"
#include "LedMatrix.h"

class NumberDisplay
{
    public:
        NumberDisplay(LedMatrix* matrix);

        /***
         * Displays a number on the matrix.
         * The matrix can contain only two digits, if the number is greater that 100, only the last
         * digits will be displayed.
         * @param number the number to display on the matrix
         * @param color the color of the number */
        void display(int number, int color);
    private:
        LedMatrix* matrix;
        const int compressedDigitSize = 4 * sizeof(char);

        /* NOTE: we cannot use an array containing all the digit as the memory of Arduino is very
                 limited ; instead, we use the following function that use a switch to allocate
                 dynamically the needed arrays using the #define contained in digit.h
        */
        /* Sets the compressed value of the digit */
        void lookUpDigit(char asciiDigit, char* compressed_out);
        /* Sets two digits (in compressed format) on the matrix */
        void setMatrixToTwoDigits(char firstDigit[4], char secondDigit[4], int color);
        /* Sets one digit (in compressed format) centered on the matrix */
        void setMatrixToOneDigit(char digit[4], int color);
};

#endif
