#include <Arduino.h>
#include "LedMatrix.h"
#include "ascii-8x8.h"
#include "AsciiDisplay.h"

AsciiDisplay::AsciiDisplay(LedMatrix* matrix)
{
    this->matrix = matrix;
}

void AsciiDisplay::display(char ascii, int color)
{
    char compressedChar[8] = LED_ASCII_EMPTY;
    lookUpAscii(ascii, compressedChar);
    matrix->setCompressed(compressedChar, color);
}

void AsciiDisplay::displayString(const char* str, int color)
{
    if (strlen(str) > 0)
    {
        this->display(str[0], color);
    }
}

void AsciiDisplay::lookUpAscii(char asciiChar, char* compressed_out)
{
    switch (asciiChar)
    {
        case 17:
        {
            char compressed[8] = LED_ASCII_ARROW_RIGHT;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 18:
        {
            char compressed[8] = LED_ASCII_ARROW_LEFT;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 19:
        {
            char compressed[8] = LED_ASCII_ARROW_UP;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 20:
        {
            char compressed[8] = LED_ASCII_ARROW_DOWN;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case ' ':
        {
            char compressed[8] = LED_ASCII_SPACE;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '!':
        {
            char compressed[8] = LED_ASCII_EXCLAMATION;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '"':
        {
            char compressed[8] = LED_ASCII_DOUBLE_QUOTE;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '#':
        {
            char compressed[8] = LED_ASCII_SHARP;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '$':
        {
            char compressed[8] = LED_ASCII_DOLLAR;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '%':
        {
            char compressed[8] = LED_ASCII_PERCENT;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '&':
        {
            char compressed[8] = LED_ASCII_AND;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '\'':
        {
            char compressed[8] = LED_ASCII_SINGLE_QUOTE;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '(':
        {
            char compressed[8] = LED_ASCII_OPEN_PARENTHESIS;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case ')':
        {
            char compressed[8] = LED_ASCII_CLOSE_PARENTHESIS;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '*':
        {
            char compressed[8] = LED_ASCII_ASTERISK;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '+':
        {
            char compressed[8] = LED_ASCII_PLUS;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case ',':
        {
            char compressed[8] = LED_ASCII_COMMA;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '-':
        {
            char compressed[8] = LED_ASCII_HYPHEN;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '.':
        {
            char compressed[8] = LED_ASCII_DOT;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '/':
        {
            char compressed[8] = LED_ASCII_SLASH;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '0':
        {
            char compressed[8] = LED_ASCII_ZERO;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '1':
        {
            char compressed[8] = LED_ASCII_ONE;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '2':
        {
            char compressed[8] = LED_ASCII_TWO;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '3':
        {
            char compressed[8] = LED_ASCII_THREE;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '4':
        {
            char compressed[8] = LED_ASCII_FOUR;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '5':
        {
            char compressed[8] = LED_ASCII_FIVE;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '6':
        {
            char compressed[8] = LED_ASCII_SIX;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '7':
        {
            char compressed[8] = LED_ASCII_SEVEN;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '8':
        {
            char compressed[8] = LED_ASCII_EIGHT;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '9':
        {
            char compressed[8] = LED_ASCII_NINE;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case ':':
        {
            char compressed[8] = LED_ASCII_COLON;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case ';':
        {
            char compressed[8] = LED_ASCII_SEMICOLON;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '<':
        {
            char compressed[8] = LED_ASCII_LESS_THAN;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '=':
        {
            char compressed[8] = LED_ASCII_EQUALS;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '>':
        {
            char compressed[8] = LED_ASCII_GREATER_THAN;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '?':
        {
            char compressed[8] = LED_ASCII_QUESTION;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '@':
        {
            char compressed[8] = LED_ASCII_AT;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'A':
        {
            char compressed[8] = LED_ASCII_A;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'B':
        {
            char compressed[8] = LED_ASCII_B;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'C':
        {
            char compressed[8] = LED_ASCII_C;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'D':
        {
            char compressed[8] = LED_ASCII_D;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'E':
        {
            char compressed[8] = LED_ASCII_E;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'F':
        {
            char compressed[8] = LED_ASCII_F;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'G':
        {
            char compressed[8] = LED_ASCII_G;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'H':
        {
            char compressed[8] = LED_ASCII_H;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'I':
        {
            char compressed[8] = LED_ASCII_I;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'J':
        {
            char compressed[8] = LED_ASCII_J;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'K':
        {
            char compressed[8] = LED_ASCII_K;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'L':
        {
            char compressed[8] = LED_ASCII_L;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'M':
        {
            char compressed[8] = LED_ASCII_M;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'N':
        {
            char compressed[8] = LED_ASCII_N;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'O':
        {
            char compressed[8] = LED_ASCII_O;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'P':
        {
            char compressed[8] = LED_ASCII_P;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'Q':
        {
            char compressed[8] = LED_ASCII_Q;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'R':
        {
            char compressed[8] = LED_ASCII_R;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'S':
        {
            char compressed[8] = LED_ASCII_S;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'T':
        {
            char compressed[8] = LED_ASCII_T;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'U':
        {
            char compressed[8] = LED_ASCII_U;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'V':
        {
            char compressed[8] = LED_ASCII_V;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'W':
        {
            char compressed[8] = LED_ASCII_W;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'X':
        {
            char compressed[8] = LED_ASCII_X;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'Y':
        {
            char compressed[8] = LED_ASCII_Y;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'Z':
        {
            char compressed[8] = LED_ASCII_Z;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '[':
        {
            char compressed[8] = LED_ASCII_OPEN_BRACKET;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '\\':
        {
            char compressed[8] = LED_ASCII_BACKSLASH;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case ']':
        {
            char compressed[8] = LED_ASCII_CLOSE_BRACKET;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '^':
        {
            char compressed[8] = LED_ASCII_CARET;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '_':
        {
            char compressed[8] = LED_ASCII_UNDERSCORE;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '`':
        {
            char compressed[8] = LED_ASCII_GRAVE_ACCENT;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'a':
        {
            char compressed[8] = LED_ASCII_a;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'b':
        {
            char compressed[8] = LED_ASCII_b;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'c':
        {
            char compressed[8] = LED_ASCII_c;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'd':
        {
            char compressed[8] = LED_ASCII_d;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'e':
        {
            char compressed[8] = LED_ASCII_e;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'f':
        {
            char compressed[8] = LED_ASCII_f;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'g':
        {
            char compressed[8] = LED_ASCII_g;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'h':
        {
            char compressed[8] = LED_ASCII_h;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'i':
        {
            char compressed[8] = LED_ASCII_i;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'j':
        {
            char compressed[8] = LED_ASCII_j;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'k':
        {
            char compressed[8] = LED_ASCII_k;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'l':
        {
            char compressed[8] = LED_ASCII_l;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'm':
        {
            char compressed[8] = LED_ASCII_m;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'n':
        {
            char compressed[8] = LED_ASCII_n;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'o':
        {
            char compressed[8] = LED_ASCII_o;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'p':
        {
            char compressed[8] = LED_ASCII_p;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'q':
        {
            char compressed[8] = LED_ASCII_q;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'r':
        {
            char compressed[8] = LED_ASCII_r;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 's':
        {
            char compressed[8] = LED_ASCII_s;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 't':
        {
            char compressed[8] = LED_ASCII_t;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'u':
        {
            char compressed[8] = LED_ASCII_u;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'v':
        {
            char compressed[8] = LED_ASCII_v;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'w':
        {
            char compressed[8] = LED_ASCII_w;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'x':
        {
            char compressed[8] = LED_ASCII_x;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'y':
        {
            char compressed[8] = LED_ASCII_y;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case 'z':
        {
            char compressed[8] = LED_ASCII_z;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '{':
        {
            char compressed[8] = LED_ASCII_OPEN_BRACE;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '|':
        {
            char compressed[8] = LED_ASCII_PIPE;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '}':
        {
            char compressed[8] = LED_ASCII_CLOSE_BRACE;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case '~':
        {
            char compressed[8] = LED_ASCII_TILDE;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case (char) 152: /* :) */
        {
            char compressed[8] = LED_ASCII_SMILEY_SMILING;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case (char) 153: /* :( */
        {
            char compressed[8] = LED_ASCII_SMILEY_SAD;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case (char) 154: /* :/ */
        {
            char compressed[8] = LED_ASCII_SMILEY_NORMAL;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case (char) 155: /* :') */
        {
            char compressed[8] = LED_ASCII_SMILEY_HAPPY;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case (char) 156: /* >:) */
        {
            char compressed[8] = LED_ASCII_SMILEY_EYEBROW;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case (char) 157: /* :Þ */
        {
            char compressed[8] = LED_ASCII_SMILEY_TONGUE;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case (char) 158: /* x) */
        {
            char compressed[8] = LED_ASCII_SMILEY_X;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case (char) 159: /* :p */
        {
            char compressed[8] = LED_ASCII_SMILEY_TONGUE_2;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case (char) 160: /* :s */
        {
            char compressed[8] = LED_ASCII_SMILEY_CONFUSED;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case (char) 161: /* :D */
        {
            char compressed[8] = LED_ASCII_SMILEY_SUPER_SMILE;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        case (char) 180: /* ´ */
        {
            char compressed[8] = LED_ASCII_RIGHT_SINGLE_QUOTE;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
        default:
        {
            char compressed[8] = LED_ASCII_EMPTY;
            memcpy(compressed_out, compressed, this->compressedCharSize);
            break;
        }
    }
}
