#ifndef drawer_h
#define drawer_h

#include <Arduino.h>
#include "LedMatrix.h"
#include "Ledevo.h"

class Drawer {
    public:
        Drawer(LedMatrix* matrix);
        void loop();

        /* the function the student will use */
        void moveCursor(int direction);
        void setCursorColor(int color);
        int getCursorLineNumber();
        int getCursorColumnNumber();

        /* the functions that the student will implement */
        void draw();
        void updateCursorPosition();

    private:
        LedMatrix* matrix;
        int x = 0;
        int y = 0;
        int cursorColor = LED_GREEN;
};

#endif
