#include <Arduino.h>
#include "LedMatrix.h"
#include "Ledevo.h"
#include "Drawer.h"

Drawer::Drawer(LedMatrix* matrix)
{
    /* init matrix */
    this->matrix = matrix;
}

void Drawer::loop()
{
    /* display blinking cursor on matrix */
    int cursorState = (millis() / 250) % 2;
    if (cursorState == 0) /* default value under cursor */
    {
        this->matrix->display();
    }
    else /* shown or hidden cursor */
    {
        int actualVal = this->matrix->get(this->x, this->y);
        int cursorVal = actualVal == LED_OFF ? LED_GREEN : LED_OFF;
        this->matrix->set(this->x, this->y, cursorVal); /* push cursor value */
        this->matrix->display();
        this->matrix->set(this->x, this->y, actualVal); /* pop cursor value */
    }
}

void Drawer::moveCursor(int direction)
{
    switch(direction)
    {
        case Ledevo::LEFT:
            this->x = max(this->x - 1, 0);
            break;
        case Ledevo::RIGHT:
            this->x = min(this->x + 1, MATRIX_SIZE - 1);
            break;
        case Ledevo::UP:
            this->y = min(this->y + 1, MATRIX_SIZE - 1);
            break;
        case Ledevo::DOWN:
            this->y = max(this->y - 1, 0);
            break;
    }
}

void Drawer::setCursorColor(int color)
{
    this->cursorColor = color;
}

int Drawer::getCursorLineNumber()
{
    return this->y + 1;
}

int Drawer::getCursorColumnNumber()
{
    return this->x + 1;
}

void Drawer::draw()
{
    /* if start button was just pressed, toggle pixel state */
    if (Ledevo::isPressed(Ledevo::START))
    {
        this->matrix->toggle(this->x, this->y);
    }
}

void Drawer::updateCursorPosition()
{
    /* move left/right */
    if (Ledevo::isPressed(Ledevo::LEFT))
    {
        this->moveCursor(Ledevo::LEFT);
    }
    if (Ledevo::isPressed(Ledevo::RIGHT))
    {
        this->moveCursor(Ledevo::RIGHT);
    }

    /* move up/down */
    if (Ledevo::isPressed(Ledevo::UP))
    {
        this->moveCursor(Ledevo::UP);
    }
    if (Ledevo::isPressed(Ledevo::DOWN))
    {
        this->moveCursor(Ledevo::DOWN);
    }
}
