// Technologie Services

(function(ext) {
	var levels = {
		HIGH:1,
		LOW:0
	};
    
	ext.resetAll = function(){};
	
	ext.runArduino = function(){};
  
  
  //Clear the matrix
  ext.ledevoClear = function()
  {
    runPackage(150);
  }
  
  //Turn a pixel ON/OFF
  ext.ledevoPixel = function(state, x, y)
  {
    var mode = {
      "Allumer":1,
      "Eteindre":0
    };
    runPackage(151, x-1, y-1, mode[state]);
  }
  
  //Toggle a pixel
  ext.ledevoToggle = function(x, y)
  {
    runPackage(152, x-1, y-1);
  }
  
  //Display a number
  ext.ledevoNumber = function(n)
  {
    runPackage(153, n);
  }
  
  //Display a character
  ext.ledevoChar = function(c)
  {
    runPackage(154, c.charCodeAt(0));
  }
  
  //Display a symbol
  ext.ledevoSymbol = function(s)
  {
    var code = {
    "→":   17,
    "←":   18,
    "↑":   19,
    "↓":   20,
    ":)":  152,
    ":(":  153,
    ":/":  154,
    ":')": 155,
    ">:)": 156,
    ":Þ":  157,
    "x)":  158,
    ":p":  159,
    ":s":  160,
    ":D":  161,
    "(z)": 174
    };
    runPackage(155, code[s]);
  }
  
  //Move the drawing cursor
  ext.moveCursor = function(direction)
  {
    runPackage(160, direction);
  }
  
  //Restart the Snake game
  ext.snakeRestart = function()
  {
    runPackage(170);
  }
  
  //Change the direction
  ext.snakeDirection = function(direction)
  {
    var dirs = {
    "la gauche": 0,
    "le haut": 1,
    "le bas": 2,
    "la droite": 3,
    };
    runPackage(171, dirs[direction]);
  }
  
  //Add 1 unit to the snake size
  ext.snakeGrow = function()
  {
    runPackage(175);
  }
  
  //Spawn a new food item
  ext.snakeFood = function()
  {
    runPackage(176);
  }
  
  //Speed up the snake movement
  ext.snakeAccelerate = function()
  {
    runPackage(177);
  }
  
  //Slow down the snake movement
  ext.snakeSlowDown = function()
  {
    runPackage(178);
  }
  
  //Game over man! Game over! (RIP B.P.)
  ext.snakeGameOver = function()
  {
    runPackage(180);
  }
  
  //----------------------
  
  //Is the button pressed?
  ext.ledevoButtonOn= function(nextID, button)
  {
    var buttons = {
      "gauche": 0,
      "haut": 1,
      "bas": 2,
      "droite": 3,
      "action": 4,
    };
    getPackage(nextID, 156, buttons[button]);
  }
  
  //Is the button released?
  ext.ledevoButtonOff= function(nextID, button)
  {
    var buttons = {
      "gauche": 0,
      "haut": 1,
      "bas": 2,
      "droite": 3,
      "action": 4,
    };
    getPackage(nextID, 157, buttons[button]);
  }
  
  //Get the current line number
  ext.getLine = function(nextID)
  {
    getPackage(nextID, 161);
  }
  
  //Get the current column number
  ext.getColumn = function(nextID)
  {
    getPackage(nextID, 162);
  }
  
  //Is the snake in a wall?
  ext.snakeWall = function(nextID)
  {
    getPackage(nextID, 172);
  }
  
  //Is the snake in itself?
  ext.snakeQueue = function(nextID)
  {
    getPackage(nextID, 173);
  }
  
  //Is the snake eating?
  ext.snakeEat = function(nextID)
  {
    getPackage(nextID, 174);
  }
  
  //Get the snake size
  ext.snakeSize = function(nextID)
  {
    getPackage(nextID, 179);
  }


/*******************************
	********************************
	*******************************/
  var device = null;
  var _rxBuf = [];
  var values = {};
	var indexs = [];
	var versionIndex = 0xFA;
    
	function runPackage(){
		var bytes = [];
		bytes.push(0xff);
		bytes.push(0x55);
		bytes.push(0);
		bytes.push(0);
		bytes.push(2);
		for(var i=0;i<arguments.length;i++){
      if(Array.isArray(arguments[i])) {
				bytes = bytes.concat(arguments[i]);
			} else {
        bytes.push(arguments[i]);
      }
		}
		bytes[2] = bytes.length-3;
		device.send(bytes);
	}
	function getPackage(){
		var bytes = [];
		bytes.push(0xff);
		bytes.push(0x55);
		bytes.push(arguments.length+1);
		bytes.push(arguments[0]);//0
		bytes.push(1);
		for(var i=1;i<arguments.length;i++){
			bytes.push(arguments[i]);
		}
		device.send(bytes);
	}

  var inputArray = [];
	var _isParseStart = false;
	var _isParseStartIndex = 0;
  
  function processData(bytes) {
		var len = bytes.length;
		if(_rxBuf.length>30){
			_rxBuf = [];
		}
		for(var index=0;index<bytes.length;index++){
			var c = bytes[index];
			_rxBuf.push(c);
			if(_rxBuf.length>=2){
				if(_rxBuf[_rxBuf.length-1]==0x55 && _rxBuf[_rxBuf.length-2]==0xff){
					_isParseStart = true;
					_isParseStartIndex = _rxBuf.length-2;
				}
				if(_rxBuf[_rxBuf.length-1]==0xa && _rxBuf[_rxBuf.length-2]==0xd&&_isParseStart){
					_isParseStart = false;
					
					var position = _isParseStartIndex+2;
					var extId = _rxBuf[position];
					position++;
					var type = _rxBuf[position];
					position++;
					//1 byte 2 float 3 short 4 len+string 5 double
					var value;
					switch(type){
						case 1:{
							value = _rxBuf[position];
							position++;
						}
							break;
						case 2:{
							value = readFloat(_rxBuf,position);
							position+=4;
							if(value<-255||value>1023){
								value = 0;
							}
						}
							break;
						case 3:{
							value = readShort(_rxBuf,position);
							position+=2;
						}
							break;
						case 4:{
							var l = _rxBuf[position];
							position++;
							value = readString(_rxBuf,position,l);
						}
							break;
						case 5:{
							value = readDouble(_rxBuf,position);
							position+=4;
						}
							break;
					}
					if(type<=5){
						if(values[extId]!=undefined){
							responseValue(extId,values[extId](value));
						}else{
							responseValue(extId,value);
						}
						values[extId] = null;
					}
					_rxBuf = [];
				}
			} 
		}
    }
	function readFloat(arr,position){
		var f= [arr[position],arr[position+1],arr[position+2],arr[position+3]];
		return parseFloat(f);
	}
	function readShort(arr,position){
		var s= [arr[position],arr[position+1]];
		return parseShort(s);
	}
	function readDouble(arr,position){
		return readFloat(arr,position);
	}
	function readString(arr,position,len){
		var value = "";
		for(var ii=0;ii<len;ii++){
			value += String.fromCharCode(_rxBuf[ii+position]);
		}
		return value;
	}
    function appendBuffer( buffer1, buffer2 ) {
        return buffer1.concat( buffer2 );
    }

    // Extension API interactions
    var potentialDevices = [];
    ext._deviceConnected = function(dev) {
        potentialDevices.push(dev);

        if (!device) {
            tryNextDevice();
        }
    }

    function tryNextDevice() {
        // If potentialDevices is empty, device will be undefined.
        // That will get us back here next time a device is connected.
        device = potentialDevices.shift();
        if (device) {
            device.open({ stopBits: 0, bitRate: 115200, ctsFlowControl: 0 }, deviceOpened);
        }
    }

    function deviceOpened(dev) {
        if (!dev) {
            // Opening the port failed.
            tryNextDevice();
            return;
        }
        device.set_receive_handler('ts',function(data) {
            processData(data);
        });
    };

    ext._deviceRemoved = function(dev) {
        if(device != dev) return;
        device = null;
    };

    ext._shutdown = function() {
        if(device) device.close();
        device = null;
    };

    ext._getStatus = function() {
        if(!device) return {status: 1, msg: 'ledevo disconnected'};
        return {status: 2, msg: 'ledevo connected'};
    }

    var descriptor = {};
	ScratchExtensions.register('ledevo', descriptor, ext, {type: 'serial'});
})({});

