#include <Arduino.h>
#include "LedMatrix.h"

LedMatrix::LedMatrix()
{

}

void LedMatrix::init()
{
    /* init adafruit matrix */
    this->bicolorMatrix.begin(0x70);

    /* init values */
    this->clear();
}

void LedMatrix::clear()
{
    this->bicolorMatrix.clear();
}

//snake compat
void LedMatrix::turnOn(int x, int y, int color)
{
    if (x < MATRIX_SIZE && y < MATRIX_SIZE)
    {
        this->bicolorMatrix.drawPixel(x, y, color);
    }
}
//snake compat
void LedMatrix::turnOff(int x, int y)
{
    if (x < MATRIX_SIZE && y < MATRIX_SIZE)
    {
        this->bicolorMatrix.drawPixel(x, y, LED_OFF);
    }
}

void LedMatrix::toggle(int x, int y)
{
    int color = this->get(x, y);
    this->set(x, y, !color);
}

void LedMatrix::set(int x, int y, int value)
{
    constrain(x, 0,7);
    constrain(y, 0,7);
    //inverse Y axis
    y = 7-y;
    this->bicolorMatrix.drawPixel(x, y, value);
}

void LedMatrix::setAll(int matrix[MATRIX_SIZE][MATRIX_SIZE])
{
    for (int line = 0; line < MATRIX_SIZE; line++)
    {
        for (int column = 0; column < MATRIX_SIZE; column++)
        {
            this->bicolorMatrix.drawPixel(column, line, matrix[line][column]);
        }
    }
}

void LedMatrix::setCompressed(char matrix[MATRIX_SIZE * MATRIX_SIZE / 8], int color)
{
    /* one bit = one led */
    for (int i = 0; i < MATRIX_SIZE * MATRIX_SIZE / 8; i++)
    {
        char current = matrix[i];
        for (int bit = 0; bit < 8; bit++)
        {
            int line   = (i * 8 + bit) / MATRIX_SIZE;
            int column = MATRIX_SIZE - ((i * 8 + bit) % MATRIX_SIZE) - 1;
            int value  = ((1 << bit) & matrix[i]) > 0 ? color : LED_OFF;
            this->set(column, 7 - line, value);
        }
    }
}

void LedMatrix::display()
{
    this->updateBlink();
    this->bicolorMatrix.writeDisplay();
}

int LedMatrix::get(int x, int y)
{
    constrain(x, 0,7);
    constrain(y, 0,7);
    int value = 0;
    y = 7 - y;
    if (x >= 0 && x < MATRIX_SIZE && y >= 0 && y < MATRIX_SIZE)
    {
        x += 7;
        x %= 8;
        uint16_t lineVal = this->bicolorMatrix.displaybuffer[y];
        bool greenIsOn   = ((lineVal >> x) & 1) == 1;
        bool redIsOn     = ((lineVal >> (x+8)) & 1) == 1;

        if (greenIsOn && redIsOn)
        {
            value = LED_YELLOW;
        }
        else if (greenIsOn && !redIsOn)
        {
            value = LED_GREEN;
        }
        else if (!greenIsOn && redIsOn)
        {
            value = LED_RED;
        }
        else
        {
            value = LED_OFF;
        }
    }
    return value;
}

void LedMatrix::updateBlink()
{
    for (int y = 0; y < MATRIX_SIZE; y++)
    {
        for (int x = 0; x < MATRIX_SIZE; x++)
        {
            /*if (this->blinkValues[y][x] != 0)
            {
                //uint16_t value = this->blinkValues[y][x];
                int color      = value & 0xff;
                int blinkSpeed = (value >> 8) & 0xff;
                this->bicolorMatrix.drawPixel(x, y, this->getBlinkValue(-blinkSpeed, 1));
            }*/
        }
    }
}

int LedMatrix::getBlinkValue(int blinkSpeed, int color)
{
  /*  int refreshSpeed = 0;
    switch (blinkSpeed)
    {
        case BLINK_VERY_SLOW:
            refreshSpeed = 2000; break;
        case BLINK_SLOW:
            refreshSpeed = 1000; break;
        case BLINK_MEDIUM_SPEED:
            refreshSpeed = 500; break;
        case BLINK_FAST:
            refreshSpeed = 250; break;
        case BLINK_VERY_FAST:
            refreshSpeed = 125; break;
    }
    return (refreshSpeed == 0 || (millis() / refreshSpeed) % 2 == 0) ? LED_OFF : color;*/
}
