#ifndef ascii_display_h
#define ascii_display_h

#include <Arduino.h>
#include "ascii-8x8.h"
#include "LedMatrix.h"

/* ASCII chars are supported. For non ascii, use this conversion table:
    ______________
    |-char-|-int-|
    | →    |  17 |
    | ←    |  18 |
    | ↑    |  19 |
    | ↓    |  20 |
    | :)   | 152 |
    | :(   | 153 |
    | :/   | 154 |
    | :')  | 155 |
    | >:)  | 156 |
    | :Þ   | 157 |
    | x)   | 158 |
    | :p   | 159 |
    | :s   | 160 |
    | :D   | 161 |
    | (z)  | 174 |
    | ´    | 180 |
    |______|_____|
*/
class AsciiDisplay
{
    public:
        AsciiDisplay(LedMatrix* matrix);

        /***
         * Displays an ascii char on the matrix.
         * The matrix can contain only one char, if the char is not supported the matrix is cleared.
         * @param ascii the char to display on the matrix
         * @param color the color of the char */
        void display(char ascii, int color);

        /***
         * Displays the first char of a string on the matrix.
         * @param str the string
         * @param color the color of the char */
        void displayString(const char* str, int color);
    private:
        LedMatrix* matrix;
        const int compressedCharSize = 8 * sizeof(char);

        /* NOTE: we cannot use an array containing all the chars as the memory of Arduino is very
        limited ; instead, we use the following function that use a switch to allocate
        dynamically the needed arrays using the #define contained in ascii.h
        */
        /* Sets the compressed value of the ascii char */
        void lookUpAscii(char asciiChar, char* compressed_out);
};

#endif
