#include <Arduino.h>
#include "LedMatrix.h"
#include "digit-4x8.h"
#include "NumberDisplay.h"

NumberDisplay::NumberDisplay(LedMatrix* matrix)
{
    this->matrix = matrix;
}

void NumberDisplay::display(int number, int color)
{
    if (number < 10) {
        /* display one centered digit */
        char digit = (char) ('0' + number);

        char compressedDigit[4] = LED_DIGIT_EMPTY;
        lookUpDigit(digit, compressedDigit);

        this->setMatrixToOneDigit(compressedDigit, color);
    } else {
        /* display two digits */
        char tensDigit  = (char) ('0' + ((number / 10) % 10)),
             unitsDigit = (char) ('0' + (number % 10));

        char tensCompressed[4]  = LED_DIGIT_EMPTY,
             unitsCompressed[4] = LED_DIGIT_EMPTY;
        lookUpDigit(tensDigit, tensCompressed);
        lookUpDigit(unitsDigit, unitsCompressed);

        this->setMatrixToTwoDigits(tensCompressed, unitsCompressed, color);
    }
}

void NumberDisplay::lookUpDigit(char asciiDigit, char* compressed_out)
{
    switch (asciiDigit)
    {
        case 48:
        {
            char compressed[4] = LED_DIGIT_0;
            memcpy(compressed_out, compressed, this->compressedDigitSize);
            break;
        }
        case 49:
        {
            char compressed[4] = LED_DIGIT_1;
            memcpy(compressed_out, compressed, this->compressedDigitSize);
            break;
        }
        case 50:
        {
            char compressed[4] = LED_DIGIT_2;
            memcpy(compressed_out, compressed, this->compressedDigitSize);
            break;
        }
        case 51:
        {
            char compressed[4] = LED_DIGIT_3;
            memcpy(compressed_out, compressed, this->compressedDigitSize);
            break;
        }
        case 52:
        {
            char compressed[4] = LED_DIGIT_4;
            memcpy(compressed_out, compressed, this->compressedDigitSize);
            break;
        }
        case 53:
        {
            char compressed[4] = LED_DIGIT_5;
            memcpy(compressed_out, compressed, this->compressedDigitSize);
            break;
        }
        case 54:
        {
            char compressed[4] = LED_DIGIT_6;
            memcpy(compressed_out, compressed, this->compressedDigitSize);
            break;
        }
        case 55:
        {
            char compressed[4] = LED_DIGIT_7;
            memcpy(compressed_out, compressed, this->compressedDigitSize);
            break;
        }
        case 56:
        {
            char compressed[4] = LED_DIGIT_8;
            memcpy(compressed_out, compressed, this->compressedDigitSize);
            break;
        }
        case 57:
        {
            char compressed[4] = LED_DIGIT_9;
            memcpy(compressed_out, compressed, this->compressedDigitSize);
            break;
        }
        default:
        {
            char compressed[4] = LED_DIGIT_EMPTY;
            memcpy(compressed_out, compressed, this->compressedDigitSize);
            break;
        }
    }
}

void NumberDisplay::setMatrixToTwoDigits(char firstDigit[4], char secondDigit[4], int color)
{
    /* clean up the matrix */
    this->matrix->clear();

    /* combine the digits */
    char combinedDigits[8];
    for (int i = 0; i < 8; i++)
    {
        bool bigEnd = (i % 2 == 0);
        if (bigEnd)
        {
            combinedDigits[i] = (firstDigit[i / 2] & 0b11110000) | ((secondDigit[i / 2] & 0b11110000) >> 4);
        }
        else
        {
            combinedDigits[i] = ((firstDigit[i / 2] & 0b00001111) << 4) | (secondDigit[i / 2] & 0b00001111);
        }
    }

    /* update matrix */
    this->matrix->setCompressed(combinedDigits, color);
}

void NumberDisplay::setMatrixToOneDigit(char digit[4], int color)
{
    /* clean up the matrix */
    this->matrix->clear();

    /* center the digit */
    char centeredDigit[8];
    for (int i = 0; i < 8; i++)
    {
        bool bigEnd = (i % 2 == 0);
        if (bigEnd)
        {
            centeredDigit[i] = (digit[i / 2] & 0b11110000) >> 2;
        }
        else
        {
            centeredDigit[i] = (digit[i / 2] & 0b00001111) << 2;
        }
    }

    /* update matrix */
    this->matrix->setCompressed(centeredDigit, color);
}
