#ifndef led_matrix_h
#define led_matrix_h

#include <Arduino.h>
#include "Adafruit_LEDBackpack.h"

#define MATRIX_SIZE 8

/* blink modes */
#define BLINK_VERY_SLOW -1
#define BLINK_SLOW -2
#define BLINK_MEDIUM_SPEED -3
#define BLINK_FAST -4
#define BLINK_VERY_FAST -5

class LedMatrix
{
    public:
        LedMatrix();
        void init();
        void clear();
        void display();
        void turnOn(int x, int y, int color);
        void turnOff(int x, int y);
        void toggle(int x, int y);
        void set(int x, int y, int value);
        void setAll(int matrix[MATRIX_SIZE][MATRIX_SIZE]);
        void setCompressed(char matrix[MATRIX_SIZE * MATRIX_SIZE / 8], int color);
        int get(int x, int y);
    private:
        int getBlinkValue(int blinkSpeed, int color);
        void updateBlink();

        Adafruit_8x8matrix bicolorMatrix;
};

#endif
