

//#define _ROBUNO_

#include <Wire.h>
#include "rgb_lcd.h"
#include "TSDHT.h"
#include "TSDigitalTube.h"
#include "TSTemperature.h"
#include "TSServoOnline.h"
#include "TSRGBLed.h"
#include "TSLedBarOnline.h"
#include "Ultrasonic.h"
#ifdef _ROBUNO_
#include <TSRobunoOnline.h>
#endif
#include "TSi2cMotorDriver.h"
#include "TSSerial.h"
#include "TSTools.h"

#include "virtualGrooveConnector.h"
#include "Seeed_RFID.h"
#include "Seeed_GasSensor.h"
#include "Seeed_DustSensor.h"
#include "Seeed_ColorSensor.h"
#include "Seeed_IRTempSensor.h"

#include "Adafruit_Sensor.h"
#include "Adafruit_HMC5883_U.h"
#include "ADXL345.h"
#include "Seeed_BME280.h"
#include "Seeed_O2Sensor.h"
#include "Seeed_FingerHeartRate.h"
#include "Adafruit_Fingerprint.h"

typedef enum
{
      I2C_COMPASS = 0x00,
      I2C_GYRO,
      I2C_COLORSENSOR,
      I2C_FINGERHEARTRATE,
      I2C_FINGERPRINT,
      I2C_BAROMETER,
      I2C_MAX
} i2c_t;
    
virtualGrooveConnector *digitalConnector[8] =  {NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL};
virtualGrooveConnector *analogConnector[4] =  {NULL, NULL, NULL, NULL};
virtualGrooveI2C *i2CConnector[I2C_MAX] ;



rgb_lcd       rgbLcd;
TSDHT         dht;
TSDigitalTube     digitalTube;
TSServo       servo;
TSRGBLed      rgbLed;
TSLedBar      ledBar;
TSi2cMotorDriver  i2cMotorDriver;
#ifdef _ROBUNO_
TSRobuno robuno;
#endif
TSSerial bt;

typedef struct MeModule
{
  int device;
  int port;
  int slot;
  int pin;
  int index;
  float values[3];
} MeModule;

union {
  byte byteVal[4];
  float floatVal;
  long longVal;
  int32_t intVal;
} val;

union {
  byte byteVal[8];
  double doubleVal;
} valDouble;

union {
  byte byteVal[2];
  short shortVal;
} valShort;

MeModule modules[12];
#if defined(__AVR_ATmega32U4__)
  int analogs[12] = {A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11};
#else
  int analogs[8] = {A0, A1, A2, A3, A4, A5, A6, A7};
#endif
String mVersion = "0.0.003";
boolean isAvailable = false;
boolean isBluetooth = false;

int len = 52;
char buffer[52];
char bufferBt[52];
byte index = 0;
byte dataLen;
byte modulesLen = 0;
boolean isStart = false;
unsigned char irRead;
char serialRead;
#define VERSION 0
#define ULTRASONIC_SENSOR   1
#define TEMPERATURE_SENSOR  2 //GROV49 v1.2
#define LIGHT_SENSOR    3
#define POTENTIONMETER    4
#define JOYSTICK      5
#define GYRO        6
#define SOUND_SENSOR    7
#define RGBLED        8
#define SEVSEG        9
#define MOTOR         10
#define SERVO         11
#define ENCODER       12
#define IR          13
#define PIRMOTION       15
#define INFRARED      16
#define LINEFOLLOWER    17
#define SHUTTER       20
#define LIMITSWITCH     21
#define BUTTON        22
#define DIGITAL       30
#define ANALOG        31
#define PWM         32
#define SERVO_PIN       33
#define TONE        34
#define STEPPER       40
#define ENCODER       41


//TS
#define I2CDISPLAY        42
#define DHT_TEMPERATURE     43
#define DHT_HUMIDITY      44
#define SERVO_ANGLE       45
#define SERVO_CONT        46
#define HEART_RATE        47
#define LEDBAR          48
#define I2CDISPLAY_CLEAR    49
#define ROBUNO_RUN        51
#define ROBUNO_STOP       52
#define ROBUNO_READ       53
#define ROBUNO_WRITE      54
#define ROBUNO_LDR        55
#define ROBUNO_SERVO      56
#define I2CDISPLAY_BACKLIGHT  57
#define APPINVENTOR_SEND    58
#define APPINVENTOR_RECEIVE   59
#define APPINVENTOR_AVAILABLE   60

#define SENSOR_RFID_AVAIL   80
#define SENSOR_RFID_READ    81
#define SENSOR_HEARTRATE_AVAIL  82
#define SENSOR_HEARTRATE_READ 83
#define SENSOR_CO2_AVAIL    84
#define SENSOR_CO2_READ     85 //CO2, temp
#define SENSOR_O2_READ      86
#define SENSOR_DUST_READ    87

#define SENSOR_COLORRGB     88 //r,g,b
#define SENSOR_COMPASS3D    89 //x,y,z
#define SENSOR_GYRO         90 //x,y,z
#define SENSOR_BAROMETER    91 
#define SENSOR_IRTEMP       92 

#define SENSOR_FINGERPRINT_DELETE        100
#define SENSOR_FINGERPRINT_ENROLLPASS1   101
#define SENSOR_FINGERPRINT_ENROLLPASS2   102 
#define SENSOR_FINGERPRINT_READAVAILABLE 103 
#define SENSOR_FINGERPRINT_READID        104 
//
#define TIMER 50

#define GET 1
#define RUN 2
#define RESET 4
#define START 5

float angleServo    = 90.0;
unsigned char prevc   = 0;
double lastTime     = 0.0;
double currentTime    = 0.0;

void setup()
{
  for (int ii2c=0; ii2c<I2C_MAX; ii2c++)
  {
    i2CConnector[ii2c] = NULL;
  }
#ifdef _ROBUNO_ 
  robuno.stop();
#endif
  pinMode(13, OUTPUT);
  digitalWrite(13, HIGH);
  delay(300);
  digitalWrite(13, LOW);
  
  
  Serial.begin(115200);
  sendString(mVersion);
  #if defined(__AVR_ATmega32U4__)
    Serial1.begin(115200);
  #endif
  
    Wire.begin();
  rgbLcd.begin(16, 2);
}


void loop() {
  currentTime = millis() / 1000.0 - lastTime;
  /*if(ir.buttonState()==1){
  if(ir.available()>0){
  irRead = ir.read();
  }
  }else{
  irRead = 0;
  }*/
  //Recepteur IR
  /*unsigned char t = ir.poll();
  if (t != 0)
  {
  Serial.println(t);
  }
  */
  
  if (readSerial())
  {
    unsigned char c = serialRead & 0xff;

    if (c == 0x66 && isStart == false) 
    {
      if (prevc == 0xff) 
      {
        index = 1;
        isStart = true;
      }
    } else {
      prevc = c;
      if (isStart) 
      {
        if (index == 2) 
        {
          dataLen = c;
        } else if (index > 2) {
          dataLen--;
        }
        writeBuffer(index, c);
      }
    }
    index++;
    if (index > 51) 
    {
      index = 0;
      isStart = false;
    }
    if (isStart && dataLen == 0 && index > 3) 
    {
      isStart = false;
      parseData();
      index = 0;
    }
  }
}

unsigned char readBuffer(int index) {
  return isBluetooth ? bufferBt[index] : buffer[index];
}

void writeBuffer(int index, unsigned char c) {
  if (isBluetooth) {
    bufferBt[index] = c;
  } else {
    buffer[index] = c;
  }
}

void writeHead() { 
  writeSerial(0xf1);
  writeSerial(0xff);
  writeSerial(0x66);
}

void writeEnd() {
  Serial.println();
#if defined(__AVR_ATmega32U4__)
  Serial1.println();
#endif
}

void writeSerial(unsigned char c) {
  Serial.write(c);
#if defined(__AVR_ATmega32U4__)
  Serial1.write(c);
#endif
}

bool readSerial()
{
  if (Serial.available())
  {
    serialRead = Serial.read();
    return true;
  }
  return false;
}
/*****************************************************
  parseData
    ff 55 len idx action device port  slot  data a
    0  1  2   3   4      5      6     7     8
****************************************************/
void parseData() {
  isStart    = false;
  int idx   = readBuffer(3);
  int action  = readBuffer(4);
  int device  = readBuffer(5);
  switch (action) {
    case GET:
    {
      writeHead();
      writeSerial(idx);
      readSensor(device);
      writeEnd();
      break;
    }
    case RUN:
    {
      runModule(device);
      callOK();
      break;
    }
    case RESET:
    {
      callOK();
      break;
    }
    case START:
    {
      callOK();
      break;
    }
  }
}

void callOK() {
  writeSerial(0xf0);
  writeSerial(0xff);
  writeSerial(0x66);
  writeEnd();
}


//--------------------------------
void sendByte(char c) {
  writeSerial(1);
  writeSerial(c);
}
//--------------------------------
void sendString(String s) {
  int l = s.length();
  writeSerial(4);
  writeSerial(l);
  for (int i = 0; i < l; i++) {
    writeSerial(s.charAt(i));
  }
}
void sendString2(char device, char flag, char nb, int32_t *vals) {
  writeSerial(0x6);
  writeSerial((3+(nb*4)));
  writeSerial(device);
  writeSerial(flag);
  writeSerial(nb);
  for (int i = 0; i < nb; i++) {
      for (int k = 0; k < 4; k++) {writeSerial((vals[i]>>(k*8))&0xff);}
  }
}
//--------------------------------
void sendFloat(float value) {
  writeSerial(0x2);
  val.floatVal = value;
  writeSerial(val.byteVal[0]);
  writeSerial(val.byteVal[1]);
  writeSerial(val.byteVal[2]);
  writeSerial(val.byteVal[3]);
}
//--------------------------------
void sendShort(double value) {
  writeSerial(3);
  valShort.shortVal = value;
  writeSerial(valShort.byteVal[0]);
  writeSerial(valShort.byteVal[1]);
  writeSerial(valShort.byteVal[2]);
  writeSerial(valShort.byteVal[3]);
}
//--------------------------------
void sendDouble(double value) {
  writeSerial(2);
  valDouble.doubleVal = value;
  writeSerial(valDouble.byteVal[0]);
  writeSerial(valDouble.byteVal[1]);
  writeSerial(valDouble.byteVal[2]);
  writeSerial(valDouble.byteVal[3]);
}
//--------------------------------
short readShort(int idx) {
  valShort.byteVal[0] = readBuffer(idx);
  valShort.byteVal[1] = readBuffer(idx + 1);
  return valShort.shortVal;
}
//--------------------------------
float readFloat(int idx) {
  val.byteVal[0] = readBuffer(idx);
  val.byteVal[1] = readBuffer(idx + 1);
  val.byteVal[2] = readBuffer(idx + 2);
  val.byteVal[3] = readBuffer(idx + 3);
  return val.floatVal;
}


//--------------------------------
void runModule(int device) 
{
  /**************************************************
      ff 55    len  idx  action  device  port  param1 param2 ...
    0  1       2   3     4      5      6      7     8
  ***************************************************/
  //0xff 0x66  0x6  0x0  0x1     0xa     0x9   0x0   0x0   0xa
  int port = readBuffer(6);
  int pin  = port;
  switch (device) {
    case MOTOR:
    {
      int direction   = readBuffer(7);
      int speed1    = readBuffer(8);
      int speed2    = readBuffer(9);
      i2cMotorDriver.MotorSpeedSetAB(speed1, speed2);
      i2cMotorDriver.MotorDirectionSet(direction);
      break;
    }
    case STEPPER:
    case ENCODER:
    case RGBLED:
    {
      int id    = readBuffer(7);
      int red   = readBuffer(8);
      int green   = readBuffer(9);
      int blue  = readBuffer(10);
      rgbLed.setColorRGB(pin, pin + 1, id, red, green, blue);
      break;
    }
    case SERVO:
    case SEVSEG:
    {
      digitalTube.show(pin, readBuffer(7), readBuffer(8), (bool)readBuffer(9));
      break;
    }
    case LIGHT_SENSOR:
    case SHUTTER:
    case SERVO_PIN:
      break;      
    case PWM:
    {
      pinMode(pin, OUTPUT);
      int v = readBuffer(7);
      analogWrite(pin, v);
      break;
    }
    case TONE:
    {
      pinMode(pin, OUTPUT);
      int hz = readShort(7);
      int ms = readShort(9);
      if (ms > 0) {
        tone(pin, hz, ms);
      } else {
        noTone(pin);
      }
      break;
    }
    case TIMER:
      lastTime = millis() / 1000.0;
      break;
      
    case DIGITAL:
    {
      pinMode(pin, OUTPUT);
      int v = readBuffer(7);
      digitalWrite(pin, v);
      break;
    }
      
    //************************************//
    //      TS actuators
    //************************************//
    case SERVO_ANGLE:
    {
      int val   = readBuffer(7);
      int speed   = readBuffer(8);
      int trim  = readBuffer(9);
      servo.write(pin, val, speed);
      break;
    }
    case SERVO_CONT:
    {
      int val   = readBuffer(7);
      bool dir  = readBuffer(8);
      int trim  = readBuffer(9);
      servo.write(pin, val, dir, trim - 90);
      break;
    }
    case I2CDISPLAY:
    {
      int line = readBuffer(7);
      int len  = readBuffer(8);
      String s;
      for (byte i = 9; i < 9 + len; i++)
      {
        s += buffer[i];
      }
      rgbLcd.setCursor(0, line);
      rgbLcd.print(s);
      rgbLcd.print("                ");
      break;
    }
    case I2CDISPLAY_CLEAR:
    {
      rgbLcd.clear();
      break;
    }
    case I2CDISPLAY_BACKLIGHT:
    {
      int r = pin;
      int g = readBuffer(7);
      int b = readBuffer(8);
      rgbLcd.setRGB(r, g, b);
      break;
    }
    case LEDBAR:
    {
      int level = readBuffer(7);
      ledBar.setLevel(pin, (float)level);
      break;
    }
    
    //--------------------
#ifdef _ROBUNO_ 
    case ROBUNO_RUN:
    {
      byte direction = pin;
      byte speed = readBuffer(7);
      robuno.run(direction, speed);
      break;
    }
    case ROBUNO_STOP:
    {
      robuno.stop();
      break;
    }
    case ROBUNO_SERVO:
    {
      robuno.enableServo();
      break;
    }
    case ROBUNO_WRITE:
    {
      bool state = readBuffer(7);
      robuno.write(pin, state);
      break;
    }
#endif
    //--------------------
   /* case APPINVENTOR_SEND:
    {
      int len = readBuffer(7);
      String s;
      for (byte i = 8; i < 8 + len; i++)
      {
        s += buffer[i];
      }
      bt.send(pin, pin+1, s);
      break;
    }*/
  }
}

#define _PARAM_LENGTH   7
#define _PARAM1_  _PARAM_LENGTH+1
#define _PARAM2_  _PARAM1_+1
#define _PARAM3_  _PARAM2_+1

void readSensor(int device) {
  /**************************************************
    ff 55 len idx action device port slot data a
    0  1  2   3   4      5      6    7    8
  ***************************************************/
  float value = 0.0;
  int port, slot, pin;
  port  = readBuffer(6);
  pin   = port;

  switch (device) {
    case  ULTRASONIC_SENSOR:
    {
      pinMode(pin, INPUT);
      Ultrasonic us(pin);
      sendShort(us.MeasureInCentimeters());
      break;
    }
    case  TEMPERATURE_SENSOR:
    {
      pin = analogs[pin];
      pinMode(pin, INPUT);
      sendFloat(getTemperature(analogRead(pin), 100000.0f, 4275));
      break;
    }
    case  LIGHT_SENSOR:
    case  SOUND_SENSOR:
    case  POTENTIONMETER:
    case  JOYSTICK:
    {
      pinMode(pin, INPUT);
      sendByte(analogRead(pin) > 1000);
      break;
    }
    case  INFRARED:
    case  PIRMOTION:
    case  LINEFOLLOWER:
    case  LIMITSWITCH:
    case  GYRO:
      break;
    case  VERSION:
    {
      sendString(mVersion);
      break;
    }
    
    
    case  DIGITAL:
    {
      pinMode(pin, INPUT);
      sendFloat(digitalRead(pin));
      break;
    }
    case  ANALOG:
    {
      pin = analogs[pin];
      pinMode(pin, INPUT);
      sendFloat(analogRead(pin));
      break;
    }
    case TIMER:
      sendFloat((float)currentTime);
      break;
      
    //************************************//
    //      TS sensors
    //************************************//
    
    //--------------------
    case DHT_TEMPERATURE:
      sendFloat(dht.readTemperature(pin));
      //char buffer[10];
      //dtostrf(dht.readTemperature(pin), 5, 2, buffer);
      //String tem = String(buffer);
      break;
    case DHT_HUMIDITY:
      sendFloat(dht.readHumidity(pin));
      break;

    //--------------------
    // RFID Sensor
    //--------------------
    case SENSOR_RFID_AVAIL:
    {
      if (digitalConnector[pin]==NULL)                      // test si le port à déjà été déclaré
        digitalConnector[pin] = new Seeed_RFID(pin, pin+1);         // aucun capteur sur le port, je lui affecte un capteur type RFID (fait une seule fois)
      sendByte( ((Seeed_RFID *)digitalConnector[pin])->isAvailable() );   // retourne la valeur si capteur est présent?
      break;      
    }
    case SENSOR_RFID_READ:
    {
      if (digitalConnector[pin]==NULL)                      // test si le port à déjà été déclaré
        digitalConnector[pin] = new Seeed_RFID(pin, pin+1);         // aucun capteur sur le port, je lui affecte un capteur type RFID(fait une seule fois)
      sendString(String( ((Seeed_RFID *)digitalConnector[pin])->cardNumber() )); // retourne la valeur du capteur lu
      break;      
    }
    //--------------------
    // Finger HR Sensor
    //--------------------
    case SENSOR_HEARTRATE_AVAIL:
    {
      //int id = getI2Cid("fingerHR");
      if (i2CConnector[I2C_FINGERHEARTRATE]==NULL)  i2CConnector[I2C_FINGERHEARTRATE] = new Seeed_FingerHeartRate();  
      Seeed_FingerHeartRate *tmp = (Seeed_FingerHeartRate*)i2CConnector[I2C_FINGERHEARTRATE];
      sendByte(tmp->isAvailable());

      break;
    }
    case SENSOR_HEARTRATE_READ:
    {
      //int id = getI2Cid("fingerHR");
      if (i2CConnector[I2C_FINGERHEARTRATE]==NULL)  i2CConnector[I2C_FINGERHEARTRATE] = new Seeed_FingerHeartRate();  
      Seeed_FingerHeartRate *tmp = (Seeed_FingerHeartRate*)i2CConnector[I2C_FINGERHEARTRATE];
      sendString( String(tmp->read())) ;

      break;
    }
    
    //--------------------
    // CO2 gas Sensor
    //--------------------
    case SENSOR_CO2_AVAIL:
    {
      if (digitalConnector[pin]==NULL)  digitalConnector[pin] = new Seeed_GasSensor(pin, pin+1);
      sendByte( ((Seeed_GasSensor *)digitalConnector[pin])->readSensor() );
      break;      
    }
    case SENSOR_CO2_READ:
    {
      if (digitalConnector[pin]==NULL)  digitalConnector[pin] = new Seeed_GasSensor(pin, pin+1);      
      sendShort( ((Seeed_GasSensor *)digitalConnector[pin])->litValeur( readBuffer(_PARAM1_) ) );
      break;      
    }
    //--------------------
    case SENSOR_O2_READ:
    {
      /*
      pin = analogs[pin];
      pinMode(pin, INPUT);
      sendShort(analogRead(pin));
      */
      if (digitalConnector[pin]==NULL)  digitalConnector[pin] = new Seeed_O2Sensor(pin, pin+1);     
      sendFloat( (float)((Seeed_O2Sensor *)digitalConnector[pin])->getConcentration() );
      break;
    }
    //--------------------
    case SENSOR_DUST_READ:
    {
      if (digitalConnector[pin]==NULL)  digitalConnector[pin] = new Seeed_DustSensor(pin, pin+1);     
      sendFloat( (float)((Seeed_DustSensor *)digitalConnector[pin])->readConcentration() );
      break;
    }
    //--------------------
    // Color Sensor
    //--------------------
    case SENSOR_COLORRGB:
    {
      // Bug must be redeclared every time (?)
      if (i2CConnector[I2C_COLORSENSOR]==NULL)  {i2CConnector[I2C_COLORSENSOR] = new Seeed_ColorSensor(); ((Seeed_ColorSensor*)i2CConnector[I2C_COLORSENSOR])->init(1);}
      int32_t R, G, B;
      ((Seeed_ColorSensor*)i2CConnector[I2C_COLORSENSOR])->readReg (0, &R, &G, &B);

      int32_t vals[3] = { R, G, B };
      sendString2(device, readBuffer(_PARAM1_), 3, vals  );
      
      //sendShort( ((Seeed_ColorSensor*)i2CConnector[I2C_COLORSENSOR])->litCouleur(readBuffer(_PARAM1_)) );
      break;
    }
    //--------------------
    // Compass Sensor
    //--------------------
    case SENSOR_COMPASS3D:
    {
      //int id = getI2Cid("compass");
      if (i2CConnector[I2C_COMPASS]==NULL)  i2CConnector[I2C_COMPASS] = new Adafruit_HMC5883_Unified(12345);  
      Adafruit_HMC5883_Unified *tmp = (Adafruit_HMC5883_Unified*)i2CConnector[I2C_COMPASS];
      if ((tmp) && (tmp->isAvailable()))
      {
        sendFloat( tmp->readAngle(readBuffer(_PARAM1_))) ;
      } else {
        float error = -36000.0;
        sendFloat(error);
      }
      break;
    }
    //--------------------
    // Gyro Sensor
    //--------------------
    case SENSOR_GYRO:
    {
      if (i2CConnector[I2C_GYRO]==NULL)  {
        i2CConnector[I2C_GYRO] = new ADXL345();
      }
      ADXL345 *tmp = (ADXL345*)i2CConnector[I2C_GYRO];
      if (tmp)
      {
        sendFloat( tmp->readAccel(readBuffer(_PARAM1_), readBuffer(_PARAM2_)) ) ;
      } else {
        float error = -36000.0;
        sendFloat(error);
      }
      break;
    }
    //--------------------
    // BAROMETER Sensor
    //--------------------
    case SENSOR_BAROMETER:
    {
          
      /*int len  = readBuffer(7)-1;
      String s;
      for (byte i = 9; i < 9 + len; i++)
      {
        s += buffer[i];
      }
      float seaPressure = s.toFloat();
      */
      if (i2CConnector[I2C_BAROMETER]==NULL)  {
          i2CConnector[I2C_BAROMETER] = new BME280();
      }
      BME280 *tmp = (BME280*)i2CConnector[I2C_BAROMETER];
      if (tmp)
      {
          //sendString( String(tmp->readBarometer(readBuffer(_PARAM1_), seaPressure*100)) ) ;
          int32_t adc_T, adc_P, adc_H;
          tmp->readReg (readBuffer(_PARAM1_), &adc_T, &adc_P, &adc_H);
          int32_t vals[/*3+9+6+*/3] = { 
                  //tmp->dig_T1, tmp->dig_T2, tmp->dig_T3,
                  //tmp->dig_P1, tmp->dig_P2, tmp->dig_P3, tmp->dig_P4, tmp->dig_P5, tmp->dig_P6, tmp->dig_P7, tmp->dig_P8, tmp->dig_P9,
                  //tmp->dig_H1, tmp->dig_H2, tmp->dig_H3, tmp->dig_H4, tmp->dig_H5, tmp->dig_H6,
                  adc_T, adc_P, adc_H  
            };
          sendString2(device, readBuffer(_PARAM1_), /*3+9+6+*/3, vals  );
      } else {
        float error = -36000.0;
        sendFloat(error);
      }
      
      break;
    }
    
    //--------------------
    // IR Temperature Sensor
    //--------------------
    /**/
    case SENSOR_IRTEMP:
    {
      Seeed_IRTempSensor tmp(A0+pin,A1+pin) ; 
      tmp.init();
      int32_t regA0=0, regA1=0;
      tmp.readReg('O', &regA0, &regA1)  ;
      
      int32_t vals[4] = { regA0, regA1, A0+pin, A2  };
      sendString2(device, readBuffer(_PARAM1_), 4, vals  );
      /*
      Seeed_IRTempSensor tmp(A0,A1) ; tmp.init();
      float r = tmp.readTemp('O')  ;
      sendString( String(r) );
      */
      break;
      /*Seeed_IRTempSensor *tmp = (Seeed_IRTempSensor*)digitalConnector[pin];
      if (tmp==NULL)  { Serial.print("init"); tmp = new Seeed_IRTempSensor(A0,A1); tmp->init();}
      float r = tmp->readTemp(readBuffer(_PARAM1_))  ;
      Serial.print(r);
      sendString( String(r));
      break;*/
    } 
    /**/   
    //--------------------
    // FINGER 
    //--------------------
    case SENSOR_FINGERPRINT_DELETE:
    {
        if (digitalConnector[pin]==NULL)   digitalConnector[pin] = new Adafruit_Fingerprint(new SoftwareSerial(pin, pin+1), true); 
        sendByte ( ((Adafruit_Fingerprint*)digitalConnector[pin])->deleteAllFingerprint() ); 
        break;
    }
    case SENSOR_FINGERPRINT_ENROLLPASS1:
    {
        if (digitalConnector[pin]==NULL)   digitalConnector[pin] = new Adafruit_Fingerprint(new SoftwareSerial(pin, pin+1), true); 
        sendByte ( ((Adafruit_Fingerprint*)digitalConnector[pin])->enrollFingerPrintPass1(readBuffer(_PARAM1_)) ); 
        break;
    }
    case SENSOR_FINGERPRINT_ENROLLPASS2:
    {
        if (digitalConnector[pin]==NULL)   digitalConnector[pin] = new Adafruit_Fingerprint(new SoftwareSerial(pin, pin+1), true); 
        sendByte ( ((Adafruit_Fingerprint*)digitalConnector[pin])->enrollFingerPrintPass2(readBuffer(_PARAM1_)) ); 
        break;
    }
    case SENSOR_FINGERPRINT_READAVAILABLE:
    {
        if (digitalConnector[pin]==NULL)   digitalConnector[pin] = new Adafruit_Fingerprint(new SoftwareSerial(pin, pin+1), true); 
        //int test = (int)((Adafruit_Fingerprint*)digitalConnector[pin])->getFingerprintIDez();
        //sendShort ( test ); 
        if (((Adafruit_Fingerprint*)digitalConnector[pin])->getFingerprintIDez())
        {
            sendByte ( 0x1 ); 
        } else {
            sendByte ( 0x00 ); 
        }
        break;
    }
    case SENSOR_FINGERPRINT_READID:
    {
        if (digitalConnector[pin]==NULL)   digitalConnector[pin] = new Adafruit_Fingerprint(new SoftwareSerial(pin, pin+1), true); 
        int id;
        //for (int i=0; i<5; i++)
        {
            id = (int)((Adafruit_Fingerprint*)digitalConnector[pin])->getIDnumber2(); //  max id 167!!
          
        }
        sendByte ( id&0xff ); 
        break;
    }

#ifdef _ROBUNO_ 
    //--------------------
    case ROBUNO_READ:
      sendByte(robuno.read(pin));
      break;
    case ROBUNO_LDR:
      sendShort(robuno.ldr_read(pin));
      break;
#endif
    //--------------------
    /*case APPINVENTOR_RECEIVE:
    {
      int len = readBuffer(7);
      String prefix;
      for (byte i = 8; i < 8 + len; i++)
      {
        prefix += buffer[i];
      }
      String s = bt.receive(pin);
      int ret=0;
      updateComVariable(s, prefix, ret);
      sendShort(ret);
      break;
    }
    case APPINVENTOR_AVAILABLE:
    {
      sendFloat(bt.dataAvailable(pin, pin+1));
    }
    break;*/
  }
}
