/*
*Library Technologie Services
* Copyright © 2016 by Technologie Services. All rights reserved
Version 1
<http://www.technologieservices.fr>
*/

#ifndef TSDHT_H
#define TSDHT_H

#include "DHT.h"

class TSDHT
{
  public:
  TSDHT():mDHT(0){;}//empty ctor
  void init(byte port)//two step ctor
  {
    if(mDHT) delete mDHT;
    mDHT = new DHT(port, 11); //DHT 11 only
    mDHT->begin();
  }
  float readTemperature(byte port)
  {
    if(!mDHT || port != mPort) init(port);
    if(mDHT) return mDHT->readTemperature();
    return 0.0f;
  }
  float readHumidity(byte port)
  {
    if(!mDHT || port != mPort) init(port);
    if(mDHT) return mDHT->readHumidity();
    return 0.0f;
  }
  private:
  DHT *mDHT;
  byte mPort;
};
 
#endif