/****************************************************************************/	
//	Hardware: Grove - I2C Color Sensor
//  Arduino IDE: Arduino-1.6
//  
//  Refactored version of the library by FrankieChu - www.seeedstudio.com
//	
/******************************************************************************/

#ifndef SEEED_COLORSENSOR
#define SEEED_COLORSENSOR

#if defined(ARDUINO) && ARDUINO >= 100
  #include "Arduino.h"
#else
  #include "WProgram.h"
#endif
#include "Registers.h"
#include "virtualGrooveConnector.h"

#undef  _OPTIM_CODE_  //doesn't work

class Seeed_ColorSensor : public virtualGrooveI2C
{
public:

	// Color Sensor LED Status
	int ledStatus;
	// Default constructor
	Seeed_ColorSensor();
	// Constructor with parameters
	Seeed_ColorSensor(
		  const int& triggerMode
		, const int& interruptSource
		, const int& interruptMode
		, const int& gainAndPrescaler
		, const int& sensorAddress);

    void init(int ledstatus);
	void readRGB();
	void readRGB(int *red, int *green, int *blue);
	void calculateCoordinate();
	void clearInterrupt();
  void readReg (char param, int32_t *R, int32_t *G, int32_t *B);
  
	/*int litRouge () { readRGB(&red,&green,&blue);  return red;}
	int litVert ()  { readRGB(&red,&green,&blue);  return green;}
	int litBleu ()  { readRGB(&red,&green,&blue);  return blue;}*/
	int litCouleur (String couleur);
	int litCouleur (char couleur);
	
private:	 
	int red, green, blue; 
	// Set trigger mode. Including free mode, manually mode, single synchronization mode or so.
#ifndef  _OPTIM_CODE_
	void setTimingReg();
	// Set interrupt source
	void setInterruptSourceReg();
	// Set interrupt mode
	void setInterruptControlReg();
	// Set gain value and pre-scaler value
	void setGain();
	// Start ADC of the colour sensor
	void setEnableADC();
#endif	
	// Used for storing the colour data
	//int readingdata_[8];
  int color_[4];
  int green_;
	int red_;
	int blue_;
	int clear_;
	
	int triggerMode_;	
	int interruptSource_;
	int interruptMode_;
	int gainAndPrescaler_;
	int sensorAddress_;
	
};

#endif
