#include "Seeed_ColorSensor.h"
#include <Wire.h>
#include <math.h>

// Default constructor
Seeed_ColorSensor::Seeed_ColorSensor()
	: virtualGrooveI2C(), triggerMode_(INTEG_MODE_FREE | INTEG_PARAM_PULSE_COUNT1)
	, interruptSource_(INT_SOURCE_CLEAR)
	, interruptMode_(INTR_LEVEL | INTR_PERSIST_EVERY)
	, gainAndPrescaler_(GAIN_1 | PRESCALER_1)
	, sensorAddress_(COLOR_SENSOR_ADDR)
{	
	// move code to init fonction
	/*
	Seeed_ColorSensor::setTimingReg(); 
	Seeed_ColorSensor::setInterruptSourceReg();  
	Seeed_ColorSensor::setInterruptControlReg(); 
	Seeed_ColorSensor::setGain(); 
	Seeed_ColorSensor::setEnableADC(); 
	*/
}

// Constructor with parameters
Seeed_ColorSensor::Seeed_ColorSensor(
	  const int& triggerMode
	, const int& interruptSource
	, const int& interruptMode
	, const int& gainAndPrescaler
	, const int& sensorAddress)
	: virtualGrooveI2C(), triggerMode_(triggerMode)
	, interruptSource_(interruptSource)
	, interruptMode_(interruptMode)
	, gainAndPrescaler_(gainAndPrescaler)
	, sensorAddress_(sensorAddress) 
{}


void Seeed_ColorSensor::init(int ledstatus)
{
   Wire.begin();
   
#ifdef  _OPTIM_CODE_
   int reg[10] = {REG_TIMING,     triggerMode_, 
                  REG_INT_SOURCE, interruptSource_, 
                  REG_INT,        interruptMode_, 
                  REG_GAIN,       gainAndPrescaler_, 
                  REG_CTL,        CTL_DAT_INIITIATE};
   for (int stepinit =0; stepinit<5; stepinit+=2)
   {
      Wire.beginTransmission(sensorAddress_);
      Wire.write(reg[stepinit]);
      Wire.write(reg[stepinit+1]);
      Wire.endTransmission();  
      delay(10); 
   }
#else
   Seeed_ColorSensor::setTimingReg(); 
   Seeed_ColorSensor::setInterruptSourceReg();  
   Seeed_ColorSensor::setInterruptControlReg(); 
   Seeed_ColorSensor::setGain(); 
   Seeed_ColorSensor::setEnableADC(); 
#endif

   ledStatus = ledstatus;  
}

#ifndef  _OPTIM_CODE_
void Seeed_ColorSensor::setTimingReg()
{
	Wire.beginTransmission(sensorAddress_);
	Wire.write(REG_TIMING);
	Wire.write(triggerMode_);
	Wire.endTransmission();  
	delay(10); 
}

void Seeed_ColorSensor::setInterruptSourceReg()
{
	Wire.beginTransmission(sensorAddress_);
	Wire.write(REG_INT_SOURCE);
	Wire.write(interruptSource_);
	Wire.endTransmission();  
	delay(10);
}

void Seeed_ColorSensor::setInterruptControlReg()
{
	Wire.beginTransmission(sensorAddress_);
	Wire.write(REG_INT);
	Wire.write(interruptMode_);
	Wire.endTransmission();  
	delay(10);
}

void Seeed_ColorSensor::setGain()
{
	Wire.beginTransmission(sensorAddress_);
	Wire.write(REG_GAIN);
	Wire.write(gainAndPrescaler_);
	Wire.endTransmission();
}

void Seeed_ColorSensor::setEnableADC()
{
	Wire.beginTransmission(sensorAddress_);
	Wire.write(REG_CTL);
	Wire.write(CTL_DAT_INIITIATE);
	Wire.endTransmission();  
	delay(10);  
}

void Seeed_ColorSensor::clearInterrupt()
{
	Wire.beginTransmission(sensorAddress_);
	Wire.write(CLR_INT);
	Wire.endTransmission(); 
}
#endif
void Seeed_ColorSensor::readRGB()
{
	Wire.beginTransmission(sensorAddress_);
	Wire.write(REG_BLOCK_READ);
	Wire.endTransmission();
	
	Wire.beginTransmission(sensorAddress_);
	Wire.requestFrom(sensorAddress_, 8);
	delay(100);
	
	// if two bytes were received
	if(8 <= Wire.available())
	{
		/*int i;
		for(i = 0; i < 8; ++i)
		{
			readingdata_[i] = Wire.read();
			//Serial.println(readingdata_[i], BIN);
		}*/
    green_  = Wire.read() + (Wire.read() * 256) ;
    red_    = Wire.read() + (Wire.read() * 256) ;
    blue_   = Wire.read() + (Wire.read() * 256) ;
    clear_  = Wire.read() + (Wire.read() * 256) ;

	}
	
	/*Serial.print("The RGB value are: RGB( ");
	Serial.print(red_,DEC);
	Serial.print(", ");
	Serial.print(green_,DEC);
	Serial.print(", ");
	Serial.print(blue_,DEC);
	Serial.println(" )");
	Serial.print("The Clear channel value are: ");
	Serial.println(clear_,DEC);*/
}

int Seeed_ColorSensor::litCouleur(String couleur)
{
    readRGB(&red,&green,&blue);
    if (couleur=="Bleu")
    {
        return blue;      
    } else if (couleur=="Vert")
    {
        return green;      
    } else {
        return red; 
    }
}

int Seeed_ColorSensor::litCouleur(char couleur)
{
    readRGB(&red,&green,&blue);
    if (couleur=='B')
    {
        return blue;      
    } else if (couleur=='V')
    {
        return green;      
    } else { //'R'
        return red; 
    }
}

void Seeed_ColorSensor::readReg (char param, int32_t *R, int32_t *G, int32_t *B)
{
    Wire.beginTransmission(sensorAddress_);
    Wire.write(REG_BLOCK_READ);
    Wire.endTransmission();
    
    Wire.beginTransmission(sensorAddress_);
    Wire.requestFrom(sensorAddress_, 8);
    delay(100);
    *G   = Wire.available();
    if (8 <= Wire.available())
    {  
        for (int i=0; i<4; i++)
        {
            color_[i]  =  Wire.read() + (Wire.read() * 256) ;
        }
    }
    *G   = color_[0];
    *R   = color_[1];
    *B   = color_[2];   
}


void Seeed_ColorSensor::readRGB(int *red, int *green, int *blue)
{
	Wire.beginTransmission(sensorAddress_);
	Wire.write(REG_BLOCK_READ);
	Wire.endTransmission();
	
	Wire.beginTransmission(sensorAddress_);
	Wire.requestFrom(sensorAddress_, 8);
	delay(100);

	// if two bytes were received

#ifdef  _OPTIM_CODE_
  // green_ = color_[1]
  // red_   = color_[0]
  // blue_  = color_[2]
  // clear_ = color_[3]
  if (8 <= Wire.available())
  {  
    for (int i=0; i<4; i++)
    {
      color_[i]  =  Wire.read() + (Wire.read() * 256) ;
    }
  }
  //int tmpcolor = color_[0]; color_[0] = color_[1]; color_[1] = tmpcolor;
  double tmp;
  int maxColor;
  if ( ledStatus == 1 )
  {
      color_[1] = color_[1]  * 1.70;
      color_[2] = color_[2] * 1.35;
  }
  maxColor = max(color_[1], color_[0]);
  maxColor = max(maxColor, color_[2]);
  if (( ledStatus == 1 ) && (maxColor < 256))
  {
      tmp = 1;
  } else {
      tmp = 250.0/maxColor;
  }
  color_[0]  *= tmp;
  color_[1]  *= tmp;
  color_[2]  *= tmp;

  int minColor = min(color_[1], color_[0]);
  minColor     = min(maxColor,  color_[2]);
  maxColor     = max(color_[1], color_[0]);
  maxColor     = max(maxColor,  color_[2]);
  
  int greenTmp = color_[0];
  int redTmp   = color_[1];
  int blueTmp  = color_[2];

  int thr1 = (maxColor == redTmp && greenTmp >= 2*blueTmp && greenTmp >= 0.2*redTmp)?2:1;  //orange
  int thr2 = (maxColor == redTmp && greenTmp <= blueTmp && blueTmp >= 0.2*redTmp)?2:1; //pink
  int thr1c[3]; 
  int thr2c[3]; 
  
  thr1c[0] = thr1; 
  thr1c[1] = 1; 
  thr1c[2] = thr1;
  thr2c[0] = 1;    
  thr2c[1] = 1; 
  thr2c[2] = thr2;
  
  
  for (int i=0; i<3; i++)
  {
      if(color_[i] < 0.8*maxColor && color_[i] >= 0.6*maxColor)
      {
          color_[i] *= 0.4;
      } else if(color_[i] < 0.6*maxColor)
      {
          
          color_[i] /= thr1c[i]; // green , blue 
          color_[i] /= thr2c[i]; // blue
          color_[i] *= 0.2; // red, green, blue
      }
  }
  minColor = min(color_[1], color_[0]);
  minColor = min(maxColor, color_[2]);
  if(maxColor == color_[0] && color_[1] >= 0.85*maxColor && minColor == color_[2])            //yellow
  {
    color_[1] = maxColor;
    color_[2] *= 0.4;
  }
  
  *red   = color_[1];
  *green = color_[0];
  *blue  = color_[2];
#else
  /*if(8 <= Wire.available())
  {
    int i;
    for(i = 0; i < 8; ++i)
    {
      readingdata_[i] = Wire.read();
      //Serial.println(readingdata_[i], BIN);
    }
  }*/
  green_	= Wire.read() + (Wire.read() * 256) ;
	red_ 	  = Wire.read() + (Wire.read() * 256) ;
	blue_	  = Wire.read() + (Wire.read() * 256) ;
	clear_	= Wire.read() + (Wire.read() * 256) ;
	
	double tmp;
	int maxColor;
	
	if ( ledStatus == 1 )
	{
		red_  = red_  * 1.70;
		blue_ = blue_ * 1.35;

		maxColor = max(red_, green_);
		maxColor = max(maxColor, blue_);
	   
		if(maxColor > 255)
		{
			tmp = 250.0/maxColor;
			green_	*= tmp;
			red_ 	*= tmp;
			blue_	*= tmp;
		}
	}
	if ( ledStatus == 0 )
	{
		maxColor = max(red_, green_);
		maxColor = max(maxColor, blue_);
	   
		tmp = 250.0/maxColor;
		green_	*= tmp;
		red_ 	*= tmp;
		blue_	*= tmp;

	}
	
	int minColor = min(red_, green_);
	minColor = min(maxColor, blue_);
	maxColor = max(red_, green_);
	maxColor = max(maxColor, blue_);
	
	int greenTmp = green_;
	int redTmp 	 = red_;
	int blueTmp	 = blue_;
 
//when turn on LED, need to adjust the RGB data,otherwise it is almost the white color
	if(red_ < 0.8*maxColor && red_ >= 0.6*maxColor)
	{
		red_ *= 0.4;
    }
	else if(red_ < 0.6*maxColor)
	{
		red_ *= 0.2;
    }
	
	if(green_ < 0.8*maxColor && green_ >= 0.6*maxColor)
	{
		green_ *= 0.4;
    }
	else if(green_ < 0.6*maxColor)
	{
		if (maxColor == redTmp && greenTmp >= 2*blueTmp && greenTmp >= 0.2*redTmp)				//orange
		{
			green_ *= 5;
		}
		green_ *= 0.2;
    }
  
	if(blue_ < 0.8*maxColor && blue_ >= 0.6*maxColor)
	{
		blue_ *= 0.4;
    }
	else if(blue_ < 0.6*maxColor)
	{
		if (maxColor == redTmp && greenTmp >= 2*blueTmp && greenTmp >= 0.2*redTmp)				//orange
		{
			blue_ *= 0.5;
		}
		if (maxColor == redTmp && greenTmp <= blueTmp && blueTmp >= 0.2*redTmp)					//pink
		{
			blue_  *= 5;
		}
		blue_ *= 0.2;
    }
	
	minColor = min(red_, green_);
	minColor = min(maxColor, blue_);
	if(maxColor == green_ && red_ >= 0.85*maxColor && minColor == blue_)						//yellow
	{
		red_ = maxColor;
		blue_ *= 0.4;
    }
	
	*red   = red_;
	*green = green_;
	*blue  = blue_;
#endif
}

void Seeed_ColorSensor::calculateCoordinate()
{
	double X;
	double Y;
	double Z;
	double x;
	double y;
	
	X = (-0.14282) * red_ + (1.54924) * green_ + (-0.95641) * blue_;
	Y = (-0.32466) * red_ + (1.57837) * green_ + (-0.73191) * blue_;
	Z = (-0.68202) * red_ + (0.77073) * green_ + (0.563320) * blue_;
	
	x = X / (X + Y + Z);
	y = Y / (X + Y + Z);
	
	if( (X > 0) && ( Y > 0) && ( Z > 0) )
	{
		Serial.println("The x,y values are(");
		Serial.print(x, 2);
		Serial.print(" , ");
		Serial.print(y, 2);
		Serial.println(")");
	}
	else
		Serial.println("Error: overflow!");
}
