// Technologie Services

(function(ext) {
    var device = null;
    var _rxBuf = [];

    
	var levels = {
		HIGH:1,
		LOW:0
	};
	var pins = {
		"D0":0,
		"D2":2,
		"D3":3,
		"D4":4,
		"D5":5,
		"D6":6,
		"D7":7,
		"D8":8,
		"A0":0,
		"A1":1,
		"A2":2,
		"A3":3
	};
	var values = {};
	var indexs = [];

	var	_I2CDISPLAY 			=	42;
	var	_DHT_TEMPERATURE 		=	43;
	var	_DHT_HUMIDITY 			=	44;
	var	_SERVO_ANGLE 			=	45;
	var	_SERVO_CONT 			=	46;
	var	_HEART_RATE 			=	47;
	var	_LEDBAR 				=	48;
	var	_I2CDISPLAY_CLEAR 		=	49;
	var	_ROBUNO_RUN 			=	51;
	var	_ROBUNO_STOP 			=	52;
	var	_ROBUNO_READ 			=	53;
	var	_ROBUNO_WRITE 			=	54;
	var	_ROBUNO_LDR 			=	55;
	var	_ROBUNO_SERVO 			=	56;
	var	_I2CDISPLAY_BACKLIGHT 	=	57;
	var	_APPINVENTOR_SEND 		=	58;
	var	_APPINVENTOR_RECEIVE 	=	59;
	var	_APPINVENTOR_AVAILABLE 	=	60;


	var	_SENSOR_RFID_AVAIL		=	80;
	var	_SENSOR_RFID_READ		=	81;
	var	_SENSOR_HEARTRATE_AVAIL	=	82;
	var	_SENSOR_HEARTRATE_READ	=	83;
	var	_SENSOR_CO2_AVAIL		=	84;
	var	_SENSOR_CO2_READ		=	85; //CO2, temp
	var	_SENSOR_O2_READ			=	86;
	var	_SENSOR_DUST_READ		=	87;
	var	_SENSOR_COLORRGB		=	88; //r,g,b
	var	_SENSOR_COMPASS3D		=	89; //x,y,z	
	var	_SENSOR_GYRO			=	90; //x,y,z	
	var	_SENSOR_BAROMETER		=	91; 
	var	_SENSOR_IRTEMP			=	92; 


	var	_SENSOR_FINGERPRINT_DELETE			=	100; 
	var	_SENSOR_FINGERPRINT_ENROLLPASS1		=	101; 
	var	_SENSOR_FINGERPRINT_ENROLLPASS2		=	102; 
	var	_SENSOR_FINGERPRINT_READAVAILABLE	=	103; 
	var	_SENSOR_FINGERPRINT_READID			=	104; 
	
	var defaultSeaPresure = 1013.25;
	
	var versionIndex = 0xFA;
    
	ext.resetAll = function(){};
	
	ext.runArduino = function(){};
  
	ext.digitalWrite = function(label, pin, level) {
        runPackage(30,typeof pin=="number"?pin:pins[pin],typeof level=="number"?level:levels[level]);
    };
	ext.digitalRead = function(nextID, label, pin) {
		getPackage(nextID, 30, typeof pin=="number"? pin : pins[pin]);
	};
	ext.analogRead = function(nextID, label, pin) {
		getPackage(nextID, 31, typeof pin=="number"? pin : pins[pin]);
	};
	ext.analogWrite = function(label, pin, pwm) {
        runPackage(32,typeof pin=="number"?pin:pins[pin],pwm);
    };
	
	//Arduino map() implementation
	ext.map = function(nextID, val, in_min, in_max, out_min, out_max) {
		var newVal = ( val - in_min ) * ( out_max - out_min ) / ( in_max - in_min ) + out_min;
		responseValue(nextID, newVal);
	};
	ext.timerRead = function(nextID){
		getPackage(nextID, 50);
	};
	//Timer reset
	ext.timerWrite = function(nextID){
		runPackage(50);
	};
	
	//--------------------
	//Afficheur 7 segments
	//--------------------
	ext.sevSegDisplayWrite = function (val, pin, dots) 
	{
		runPackage(9,typeof pin=="number"?pin:pins[pin], Math.floor(val/100), val%100, dots=="afficher"?1:0);
	};
	
	//--------------------
	//Afficheur i2c
	//--------------------
	ext.i2cDisplayWrite = function (text, line) 
	{
		var charCodes = [];//char splitted string
		var len = String(text).length;
		for(var i=0;i<len;i++) {
			charCodes.push(String(text).charCodeAt(i));
		}
		var port = 0; //dummy port
		runPackage(_I2CDISPLAY, port, line, String(text).length, charCodes);
	};
    ext.i2cDisplayClear = function () 
	{
		var port = 0; //dummy port
		runPackage(_I2CDISPLAY_CLEAR, port);
	};
	ext.i2cDisplayRGB = function (r, g, b) 
	{
		var port = 0; //dummy port
		runPackage(_I2CDISPLAY_BACKLIGHT, r, g, b);
	};
	
		
	//--------------------
	// RFID
	//--------------------
	ext.RFIDavailable = function (nextID, pin) 
	{
		getPackage(nextID, _SENSOR_RFID_AVAIL, typeof pin=="number"?pin:pins[pin]);
	};
	ext.readRFID = function (nextID, pin) 
	{
		getPackage(nextID, _SENSOR_RFID_READ, typeof pin=="number"?pin:pins[pin]);
	};

	//--------------------
	// Chainaible RGB color & I2C sensor color
	//--------------------
	ext.setColorRGB = function (nextID, pin) 
	{
		//getPackage(nextID, 43,typeof pin=="number"?pin:pins[pin]);
	};
	ext.readColorRGB = function (nextID,  params, pin) 
	{
		var charCodes = [];
		if(params == "Rouge")
		{
			charCodes.push(0x52); //"R"
		}
		else if(params == "Bleu")
		{
			charCodes.push(0x42); //"B"
		} else {// "Vert"
			charCodes.push(0x56); //"V"
		}
		getPackage(nextID, _SENSOR_COLORRGB, typeof pin=="number"? pin:pins[pin], 1, charCodes);
	};
	//--------------------
	// Finger Heart Rate
	//--------------------
	ext.fingerHeartRateAvailable = function (nextID, pin) 
	{
		getPackage(nextID, _SENSOR_HEARTRATE_AVAIL, typeof pin=="number"? pin:pins[pin]);
	};	
	ext.fingerHeartRate = function (nextID, pin) 
	{
		getPackage(nextID, _SENSOR_HEARTRATE_READ, typeof pin=="number"? pin:pins[pin]);
	};

	//--------------------
	// Gas CO2 and gas O2  Sensor 
	//--------------------
	ext.CO2SensorAvailable = function (nextID, pin) 
	{
		getPackage(nextID, _SENSOR_CO2_AVAIL, typeof pin=="number"? pin:pins[pin]);
	};	
	ext.readCO2Sensor = function (nextID, params, pin) 
	{
		var charCodes = [];
		if (params == "CO2") 
		{
			charCodes.push(0x43); //"C"
		}
		else if (params == "Temperature")
		{
			charCodes.push(0x54); //"T"
		} else {
			charCodes.push(0x43); //default => "C"
		}
		getPackage(nextID, _SENSOR_CO2_READ, typeof pin=="number"? pin:pins[pin], 1, charCodes);
	};	
	ext.readO2Sensor = function (nextID, pin) 
	{
		getPackage(nextID, _SENSOR_O2_READ, typeof pin=="number"? pin:pins[pin]);
	};	
	ext.readDustSensor = function (nextID, pin) 
	{
		getPackage(nextID, _SENSOR_DUST_READ, typeof pin=="number"? pin:pins[pin]);
	};		
	//--------------------
	// Gyro & compass
	//--------------------
	ext.readAccel = function (nextID, param1, param2, pin) 
	{
		
		var charCodes = [];
				
		if (param1 == "Rotation")
		{
			charCodes.push(0x52); //"R"
		}
		else
		{
			charCodes.push(0x56); //"VS"
		} 
		if (param2 == "X")
		{
			charCodes.push(0x58);
		}
		else if (param2 == "Y")
		{
			charCodes.push(0x59);
		} else {// "Z"
			charCodes.push(0x5A); //"Z"
		}
		getPackage(nextID, _SENSOR_GYRO, typeof pin=="number"? pin:pins[pin], 1, charCodes);
	};	
	ext.readCompass3Axis = function (nextID, param1, pin) 
	{
		var charCodes = [];
				
		if (param1 == "X")
		{
			charCodes.push(0x58);
		}
		else if (param1 == "Y")
		{
			charCodes.push(0x59);
		} else {// "Z"
			charCodes.push(0x5A); //"Z"
		}
		getPackage(nextID, _SENSOR_COMPASS3D, typeof pin=="number"? pin:pins[pin], 1, charCodes);
	};
	//--------------------
	// I2C Barometer
	//--------------------
	ext.setSeaPressure = function (nextID, param1) 
	{
		defaultSeaPresure = param1;
	};
	ext.readBarometer = function (nextID, param1, pin) 
	{
		var charCodes = [];
				
		if (param1 == "Température")
		{
			charCodes.push(0x54);
		}
		else if (param1 == "Pression")
		{
			charCodes.push(0x50);
		} else if (param1 == "Humidité")
		{
			charCodes.push(0x48);
		} else { // "A"
			charCodes.push(0x41); //"A"
		}
		strPressure = String(defaultSeaPresure);
		var len = strPressure.length;
		for(var i=0;i<len;i++) {
			charCodes.push(strPressure.charCodeAt(i));
		}
		getPackage(nextID, _SENSOR_BAROMETER, typeof pin=="number"? pin:pins[pin], len+1, charCodes);
	};
	//--------------------
	// IR Temperature
	//--------------------
	ext.irtemp = function (nextID, param1, pin) 
	{
		var charCodes = [];
				
		if (param1 == "Ambiante")
		{
			charCodes.push(0x41);
		}
		else //if (param1 == "Objet")
		{
			charCodes.push(0x4F);
		} 
		getPackage(nextID, _SENSOR_IRTEMP, typeof pin=="number"? pin:pins[pin], 1, charCodes);
	};
	//--------------------
	// FINGER PRINT
	//--------------------	
	ext.deleteAllFingerPrint = function (nextID, param1, pin) 
	{
		var charCodes = [];
		charCodes.push(param1);
		getPackage(nextID, _SENSOR_FINGERPRINT_DELETE, typeof pin=="number"? pin:pins[pin], 1, charCodes);
	};		
	ext.recordFingerPrint1 = function (nextID, param1, pin) 
	{
		var charCodes = [];
		charCodes.push(param1);
		getPackage(nextID, _SENSOR_FINGERPRINT_ENROLLPASS1, typeof pin=="number"? pin:pins[pin], 1, charCodes);
	};		
	ext.recordFingerPrint2 = function (nextID, param1, pin) 
	{
		var charCodes = [];
		charCodes.push(param1);
		getPackage(nextID, _SENSOR_FINGERPRINT_ENROLLPASS2, typeof pin=="number"? pin:pins[pin], 1, charCodes);
	};	
	ext.fingerPrintAvailable = function (nextID, pin) 
	{
		getPackage(nextID, _SENSOR_FINGERPRINT_READAVAILABLE, typeof pin=="number"? pin:pins[pin]);
		
	};	
	ext.fingerPrintIDfound = function (nextID, pin) 
	{
		getPackage(nextID, _SENSOR_FINGERPRINT_READID, typeof pin=="number"? pin:pins[pin]);
		
	};		
	//--------------------
	//DHT 11
	//--------------------
	ext.dhtTemperatureRead = function (nextID, pin) 
	{
		getPackage(nextID, _DHT_TEMPERATURE,typeof pin=="number"?pin:pins[pin]);
	};
	ext.dhtHumidityRead = function (nextID, pin) 
	{
		getPackage(nextID, _DHT_HUMIDITY,typeof pin=="number"?pin:pins[pin]);
	};
	
	//--------------------
	//GROV49 v1.2
	//--------------------
	ext.temperatureRead = function (nextID, pin) 
	{
		getPackage(nextID, 2,typeof pin=="number"?pin:pins[pin]);
	};
	
	//--------------------
	//Joystick GROV78
	//--------------------
	ext.joystickRead = function (nextID, slot, pin) 
	{
		//Analog read
		var pinX = typeof pin=="number"?pin:pins[pin];
		var pinY = pinX+1;
		if(slot == "de l'axe X")
		{
			getPackage(nextID,31,pinX);//ANALOG
		}
		else if(slot == "de l'axe Y")
		{
			getPackage(nextID,31,pinY);//ANALOG
		}
		else
		{
		  getPackage(nextID, 5, pinX);//JOYSTICK
		}
	};
	//--------------------
    //Servo angle
	//--------------------
	ext.servoAngleWrite = function (pin, val, speed)
	{
		runPackage(_SERVO_ANGLE, typeof pin=="number"?pin:pins[pin], val, speed);//SERVO_ANGLE
	};
	//--------------------
	//Servo continu
	//--------------------
	ext.servoContWrite = function (pin, val, dir, trim)
	{
		trim = 90 + trim;
		runPackage(_SERVO_CONT, typeof pin=="number"?pin:pins[pin], val, dir=="inverse"?1:0, trim);//SERVO_CONT
	};
	//--------------------
	//IR
	//--------------------
	ext.irRead = function (nextID, pin)
	{
		getPackage(nextID, 13, typeof pin=="number"?pin:pins[pin]);//IR
	};
	
	//--------------------
	//RGB Led
	//--------------------
	ext.rgbLedWrite = function (index, pin, red, green, blue)
	{
		runPackage(8, typeof pin=="number"?pin:pins[pin], index, red, green, blue);//RGB Led
	};
	
	//--------------------
    //Led bar
	//--------------------
	ext.ledBarWrite = function (level, pin)
	{
		runPackage(_LEDBAR, typeof pin=="number"?pin:pins[pin], level);
	};
	
	//--------------------
	//Ultrasonic Ranger
	//--------------------
	ext.ultrasonicRangerRead = function(nextID, pin)
	{
		getPackage(nextID, 1, typeof pin=="number"?pin:pins[pin]);//US
	};
	
	//--------------------
	//i2c driver 
	//--------------------
	ext.i2cDriver = function(speed1, speed2, direction)
	{
		var directions = {
		  "en avant"	:6,
		  "en arrière"	:9,
		  "à gauche"	:5,
		  "à droite"	:10,
		}
		var port = 0;//dummy port
		runPackage(10, port, directions[direction], speed1, speed2);
	};
	//--------------------
	// AppInventor
	//--------------------
	ext.appInventorDataAvailable= function(nextID, pin) 
	{
		getPackage(nextID,_APPINVENTOR_AVAILABLE,typeof pin=="number"?pin:pins[pin]);
	};
	ext.appInventorSend = function (label, val, pin)
	{
		var charCodes = [];//char splitted string
		var str = label + ':' + val;
		var len = String(str).length;
		for(var i=0;i<len;i++) {
		  charCodes.push(String(str).charCodeAt(i));
		}
		runPackage(_APPINVENTOR_SEND, typeof pin=="number"?pin:pins[pin], len, charCodes);
	};
	ext.appInventorReceive = function (nextID, label, pin) 
	{
		var charCodes = [];//char splitted string
		var len = String(label).length;
		for(var i=0;i<len;i++) {
		  charCodes.push(String(label).charCodeAt(i));
		}
		getPackage(nextID, _APPINVENTOR_RECEIVE, typeof pin=="number"?pin:pins[pin], len, charCodes);
	};
  
	/*******************************
	********************************
	*******************************/
	function runPackage() {
		var bytes = [];
		bytes.push(0xff);
		bytes.push(0x66);
		bytes.push(0);
		bytes.push(0);
		bytes.push(2);
		for(var i=0;i<arguments.length;i++) {
			if(Array.isArray(arguments[i])) {
				bytes = bytes.concat(arguments[i]);
			} else {
				bytes.push(arguments[i]);
			}
		}
		bytes[2] = bytes.length-3;//size
		device.send(bytes);
	}
	function getPackage() {
		var bytes = [];
		bytes.push(0xff);
		bytes.push(0x66);
		bytes.push(0);
		bytes.push(arguments[0]);//0
		bytes.push(1);
		for(var i=1;i<arguments.length;i++){
			if(Array.isArray(arguments[i])) {
				bytes = bytes.concat(arguments[i]);
			} else {
				bytes.push(arguments[i]);
			}
		}
		bytes[2] = bytes.length-3;//size
		device.send(bytes);
	}

	//---------------------------------	
	function sensorRGBColor() {
		var R=0,G=0,B=0;
		var ledStatus;
		this.set = function (config) {
			ledStatus = 1;
			green_		= config[0] ;
			red_ 	  	= config[1] ;
			blue_	  	= config[2] ;
			clear_		= config[3] ;

			var tmp;
			var maxColor;

			if ( ledStatus == 1 )
			{
				red_  = red_  * 1.70;
				blue_ = blue_ * 1.35;

				maxColor = Math.max(red_, green_);
				maxColor = Math.max(maxColor, blue_);
			   
				if(maxColor > 255)
				{
					tmp = 250.0/maxColor;
					green_	*= tmp;
					red_ 	*= tmp;
					blue_	*= tmp;
				}
			}
			if ( ledStatus == 0 )
			{
				maxColor = Math.max(red_, green_);
				maxColor = Math.max(maxColor, blue_);
			   
				tmp = 250.0/maxColor;
				green_	*= tmp;
				red_ 	*= tmp;
				blue_	*= tmp;

			}

			var minColor = Math.min(red_, green_);
			minColor 	=  Math.min(maxColor, blue_);
			maxColor 	= Math.max(red_, green_);
			maxColor 	= Math.max(maxColor, blue_);

			var greenTmp = green_;
			var redTmp 	 = red_;
			var blueTmp	 = blue_;

			//when turn on LED, need to adjust the RGB data,otherwise it is almost the white color
			if(red_ < 0.8*maxColor && red_ >= 0.6*maxColor)
			{
				red_ *= 0.4;
			} else if (red_ < 0.6*maxColor)
			{
				red_ *= 0.2;
			}

			if(green_ < 0.8*maxColor && green_ >= 0.6*maxColor)
			{
				green_ *= 0.4;
			} else if(green_ < 0.6*maxColor)
			{
				if (maxColor == redTmp && greenTmp >= 2*blueTmp && greenTmp >= 0.2*redTmp)				//orange
				{
					green_ *= 5;
				}
				green_ *= 0.2;
			}

			if(blue_ < 0.8*maxColor && blue_ >= 0.6*maxColor)
			{
				blue_ *= 0.4;
			} else if(blue_ < 0.6*maxColor)
			{
				if (maxColor == redTmp && greenTmp >= 2*blueTmp && greenTmp >= 0.2*redTmp)				//orange
				{
					blue_ *= 0.5;
				}
				if (maxColor == redTmp && greenTmp <= blueTmp && blueTmp >= 0.2*redTmp)					//pink
				{
					blue_  *= 5;
				}
				blue_ *= 0.2;
			}

			minColor = Math.min(red_, green_);
			minColor = Math.min(maxColor, blue_);
			if(maxColor == green_ && red_ >= 0.85*maxColor && minColor == blue_)						//yellow
			{
				red_ = maxColor;
				blue_ *= 0.4;
			}

			R   = parseInt(red_);
			G 	= parseInt(green_);
			B  	= parseInt(blue_);
		};
		
		this.compute = function (params) { 
			if(params == 0x52) //"R"
			{
				return R;
			} else if(params == 0x42) //"B"
			{
				return B;
			} else {// 0x56 //"V"
				return G;
			}
		};
	}
	
	//---------------------------------	
	function sensorIRAnalogTemperature() {
		var currANA0, currANA1;
		
		var temp_calibration=0;       //this parameter was used to calibrate the temperature
		//var objt_calibration=0.000; //this parameter was used to calibrate the object temperature
		var temperature_range=10;    //we make a map of temperature-voltage according to sensor datasheet. 10 is the temperature step when sensor and 
									   //object distance is 9CM.
		var offset_vol=0.014;        //this parameter was used to set the mid level voltage,when put the sensor in normal environment after 10 min,
									   //the sensor output 0.For example,the surrounding temperature is 29?,but the result is 27? via the sensor,
									   //you should set the reerence to 0.520 or more,according to your sensor to change.
									   //the unit is V
		var current_temp=0;
		var reference_vol=0.500;
		var R=0;
		var voltage=0;


		var resIR=[
						 318300,302903,288329,274533,261471,249100,237381,226276,215750,205768,
						 196300,187316,178788,170691,163002,155700,148766,142183,135936,130012,
						 124400,119038,113928,109059,104420,100000,95788,91775,87950,84305,
						 80830,77517,74357,71342,68466,65720,63098,60595,58202,55916,
						 53730,51645,49652,47746,45924,44180,42511,40912,39380,37910,
						 36500,35155,33866,32631,31446,30311,29222,28177,27175,26213,
						 25290,24403,23554,22738,21955,21202,20479,19783,19115,18472,
						 17260,16688,16138,15608,15098,14608,14135,13680,13242,12819,
						 12412,12020,11642,11278,10926,10587,10260,9945,9641,9347,
						 9063,8789,8525,8270,8023,7785,7555,7333,7118,6911];
						 
		var objIR =[
		/*0*/             [ 0,-0.274,-0.58,-0.922,-1.301,-1.721,-2.183,-2.691,-3.247,-3.854,-4.516,-5.236], //
		/*1*/             [ 0.271,0,-0.303,-0.642,-1.018,-1.434,-1.894,-2.398,-2.951,-3.556,-4.215,-4.931],  //?surrounding temperature,from -10,0,10,...100
		/*2*/             [ 0.567,0.3,0,-0.335,-0.708,-1.121,-1.577,-2.078,-2.628,-3.229,-3.884,-4.597],   //?object temperature,from -10,0,10,...110
		/*3*/             [ 0.891,0.628,0.331,0,-0.369,-0.778,-1.23,-1.728,-2.274,-2.871,-3.523,-4.232],
		/*4*/             [ 1.244,0.985,0.692,0.365,0,-0.405,-0.853,-1.347,-1.889,-2.482,-3.13,-3.835],
		/*5*/             [ 1.628,1.372,1.084,0.761,0.401,0,-0.444,-0.933,-1.47,-2.059,-2.702,-3.403],
		/*6*/             [ 2.043,1.792,1.509,1.191,0.835,0.439,0,-0.484,-1.017,-1.601,-2.24,-2.936],
		/*7*/             [ 2.491,2.246,1.968,1.655,1.304,0.913,0.479,0,-0.528,-1.107,-1.74,-2.431],
		/*8*/             [ 2.975,2.735,2.462,2.155,1.809,1.424,0.996,0.522,0,-0.573,-1.201,-1.887],
		/*9*/             [ 3.495,3.261,2.994,2.692,2.353,1.974,1.552,1.084,0.568,0,-0.622,-1.301],
		/*10*/            [ 4.053,3.825,3.565,3.27,2.937,2.564,2.148,1.687,1.177,0.616,0,-0.673],
		/*11*/            [ 4.651,4.43,4.177,3.888,3.562,3.196,2.787,2.332,1.829,1.275,0.666,0],
		/*12*/            [ 5.29,5.076,4.83,4.549,4.231,3.872,3.47,3.023,2.527,1.98,1.379,0.72]
		];	
		

		function binSearch(x)// this function used for measure the surrounding temperature
		{
			var low,mid,high;
			low=0;
			//mid=0;
			high=100;
			while (low<=high)
			{
				mid=(low+high)/2;
				if(x<resIR[parseInt(mid)])
					low= mid+1;
				else//(x>resIR[mid])
					high=mid-1;
			}
			return mid;
		};

		function arraysearch(x, y)//x is the surrounding temperature,y is the object temperature
		{
			var i=0;
			var tem_coefficient=100;//Magnification of 100 times	
			i=parseInt(x/10)+1;//Ambient temperature			
			voltage=y/tem_coefficient;//the original voltage					
			var temp3;
			for(temp3=0;temp3<13;temp3++)		
			{			
				if((voltage>objIR[temp3][i])&&(voltage<objIR[temp3+1][i]))				
				{			
					return temp3;					
				}			
			}
		};
		function measureSurTemp()
		{  
			var i=0;
			var current_temp1=0;	  
			var signal=0;	  
			var tempValue=currANA0;
			tempValue=tempValue/10;	  
			var ratioTemp = (tempValue*1.1)/1023;	  
			var irR=(2000000*ratioTemp)/(2.50-ratioTemp);	  
			signal=parseInt(binSearch(irR));	  
			current_temp=signal-1+temp_calibration+(resIR[signal-1]-irR)/(resIR[signal-1]-resIR[signal]);
			return current_temp;
		};

		function measureObjectTemp()
		{
			var i=0;  
			var j=0;  
			var sur_temp=0;  
			var array_temp=0;  
			var temp1,temp2; 
			var final_temp=0;
			var objtValue=currANA1;
			
			objtValue=objtValue/10;//Averaging processing     
			temp1=objtValue*1.1/1023;//+objt_calibration; 
			sur_temp=temp1-(reference_vol+offset_vol);             

			array_temp=parseInt(arraysearch(current_temp,sur_temp*1000));        
			temp2=current_temp;        
			temp1=(temperature_range*voltage)/(objIR[array_temp+1][parseInt(temp2/10)+1]-objIR[array_temp][parseInt(temp2/10)+1]);        
			final_temp=temp2+temp1;        

			
			return temp2+temp1;	
		};

		
		this.set = function (config) {
			currANA0 = config[0];
			currANA1 = config[1];
		};
		this.compute = function (params) { 
			var ambient = measureSurTemp();
			if (params == 0x41)
			{
				return ambient.toFixed(2);
			} else { //param == 'Objet'
				return measureObjectTemp().toFixed(2);	 //ambient needed	
			}
		
		};
	};
	//---------------------------------	
	function sensorBarometer280() {
		var dig_T1,
			dig_T2,
			dig_T3,

			dig_P1,
			dig_P2,
			dig_P3,
			dig_P4,
			dig_P5,
			dig_P6,
			dig_P7,
			dig_P8,
			dig_P9,

			dig_H1,
			dig_H2,
			dig_H3,
			dig_H4,
			dig_H5,
			dig_H6;
		var t_fine;
		var altitudeMer = 101325;

		function getTemperature()
		{
			var var1, var2;

			//adc_T >>= 4;
			
			var1 = (((adc_T >> 3) - ((dig_T1 << 1))) * (dig_T2)) >> 11;
			var2 = (((((adc_T >> 4) - (dig_T1)) * ((adc_T >> 4) - (dig_T1))) >> 12) * (dig_T3)) >> 14;
			t_fine = var1 + var2;
			var T = (t_fine * 5 + 128) >> 8;
			return T/100;
		};

		function getPressure()
		{

			var p64;
			var var1, var2, p, ptmp, pmsb,plsb;
			var var2_8;
			var var2_16;
			
			var var1_12;
			
			// Call getTemperature to get t_fine
			getTemperature();
			//adc_P >>= 4; 

			var1        = (t_fine) - 128000;      //16bits
			var2        = ((var1 * var1)>>8) * dig_P6;
			var2_8      = (var2 + ((var1*dig_P5)<<(9))) >>8;
			var2_16     = ((var2_8>>4) + ((dig_P4)<<27-8-4)) >>4;
			var1        = var1>>4;
			var1_12     = ((var1 * var1 * (dig_P3))>>(16+4)) + ((var1 * (dig_P2>>4))<<(4-4));
			var1_12     = ((((1)<<(39-8-4-11))+(var1_12>>11)))*((dig_P1>>1))>>(25-12);
			if (var1_12 == 0)
			{
			  return 0; // avoid exception caused by division by zero
			}
			p = 1048576-adc_P;
			
			p64=(((p<<(23-8-4))-(var2_16<<4))*(3125.0/var1_12));
			p    = p64;//(pmsb<<16)+plsb;
			
			ptmp = (p>>(12+4));
			var1 = ((dig_P9) * ptmp * ptmp) >> 3;
			var2 = ((dig_P8) * (p>>8)) >> 3;
			p = ((p + ((var1 + var2) >> 8)) >> 8) + ((dig_P7)>>4);
			return p;
		};

		function getHumidity()
		{
		  var v_x1_u32r;

		  // Call getTemperature to get t_fine
		  getTemperature();

		  v_x1_u32r = (t_fine - (76800));
		  v_x1_u32r = (	((((adc_H << 14) - ((dig_H4) << 20) - ((dig_H5) * v_x1_u32r)) + (16384)) >> 15) *
						(((((((v_x1_u32r * (dig_H6)) >> 10) * (((v_x1_u32r * (dig_H3)) >> 11) + (32768))) >> 10) + (2097152)) * (dig_H2) + 8192) >> 14)
					 );
		 
		
		 
		  v_x1_u32r = (v_x1_u32r - (((((v_x1_u32r >> 15) * (v_x1_u32r >> 15)) >> 7) * (dig_H1)) >> 4));
		  v_x1_u32r = (v_x1_u32r < 0 ? 0 : v_x1_u32r);
		  v_x1_u32r = (v_x1_u32r > 419430400 ? 419430400 : v_x1_u32r);
		  return (v_x1_u32r>>12)/1024;
		};

		function calcAltitude(pressure, altitudeMer)
		{
			var A = pressure/altitudeMer;
			var B = 1/5.25588;
			var C = Math.pow(A,B);
			C = 1.0 - C;
			C = C /0.0000225577;
			return C;
		};	

		this.setRegisters = function (config) {
			dig_T1=config[0];
			dig_T2=config[1];
			dig_T3=config[2];

			dig_P1=config[3];
			dig_P2=config[4];
			dig_P3=config[5];
			dig_P4=config[6];
			dig_P5=config[7];
			dig_P6=config[8];
			dig_P7=config[9];
			dig_P8=config[10];

			dig_H1=config[11];
			dig_H2=config[12];
			dig_H3=config[13];
			dig_H4=config[14];
			dig_H5=config[15];
			dig_H6=config[16];
		};
		
		this.setSeaFlood = function (val) {
			altitudeMer = val;
		}
		
		this.set = function (config) {
			adc_T = config[0];
			adc_P = config[1];
			adc_H = config[2];
		};
		this.compute = function (params) { 
			if (params==0x54) 			//'T'
			{
			   return getTemperature().toFixed(1);
			} else if (params==0x41)  	//'A'
			{
				return calcAltitude(getPressure(), altitudeMer).toFixed(1); 
			} else if(params==0x48)  	//'H'
			{
				return getHumidity().toFixed(2);
			} else { // 0x50 Pressure;
				return (getPressure()/10).toFixed(2);
			} 
		
		};				
	}	
	//---------------------------------	
	
	
	var inputArray = [];
	var _isParseStart = false;
	var _isParseStartIndex = 0;
	function processData(bytes) {
		var len = bytes.length;
		if(_rxBuf.length>80){
			_rxBuf = [];
		}
		for(var index=0;index<bytes.length;index++){
			var c = bytes[index];
			_rxBuf.push(c);
			if(_rxBuf.length>=2){
				if(_rxBuf[_rxBuf.length-1]==0x66 && _rxBuf[_rxBuf.length-2]==0xff){
					_isParseStart = true;
					_isParseStartIndex = _rxBuf.length-2;
				}
				if(_rxBuf[_rxBuf.length-1]==0xa && _rxBuf[_rxBuf.length-2]==0xd&&_isParseStart){
					_isParseStart = false;
					
					var position = _isParseStartIndex+2;
					var extId = _rxBuf[position];
					position++;
					var type = _rxBuf[position];
					position++;
					//1 byte 2 float 3 short 4 len+string 5 double
					var value;
					switch(type){
						//------------------
						case 1: 
						{
							value = _rxBuf[position];
							position++;
							break;
						}
						//------------------
						case 2:
						{
							value = (readFloat(_rxBuf,position)).toFixed(2);
							position+=4;
							/*if(value<-255||value>1023){
								value = 0;
							}*/
							break;
						}
						//------------------
						case 3:
						{
							//value = "B"+readInt(_rxBuf,position, 2)+"C"+readShort(_rxBuf,position); //readShort(_rxBuf,position);
							value = readShort(_rxBuf,position);
							position+=2;
							break;
						}
						//------------------
						case 4:
						{
							var l = _rxBuf[position];
							position++;
							value = readString(_rxBuf,position,l);
							break;
						}
						//------------------
						case 5:
						{
							value = readDouble(_rxBuf,position);
							position+=4;
							break;
						}
						//------------------
						case 6:
						{
							var max 		= _rxBuf[position]; position++;
							var idDevice 	= _rxBuf[position]; position++;
							var flag 	 	= _rxBuf[position]; position++;
							var nbVar 	 	= _rxBuf[position]; position++;
							var params 		= [];
							for (var iVar=0; iVar<nbVar; iVar++)
							{
								params[iVar] = readInt(_rxBuf, position, 4);
								position+=4;
							}
							if (idDevice == _SENSOR_IRTEMP)
							{
								var sensor = new sensorIRAnalogTemperature();
								sensor.set(params);
								value = sensor.compute(flag);
							} else if (idDevice == _SENSOR_BAROMETER) {
								var paramTPH 		= [params[nbVar-3]>>4, params[nbVar-2]>>4, params[nbVar-1]];
								var sensor = new sensorBarometer280();
								//tmp.setRegisters(params);
								sensor.setRegisters([
									/*dig_T1=*/28307, 26441, 50,
									/*dig_P1=*/37344, -10750, 3024, 9167, -140, -7, 9900, -10230, 4285,
									/*dig_H1=*/75, 367, 0, 306, 50, 30
								]);
								sensor.setSeaFlood(defaultSeaPresure*100);
								sensor.set(paramTPH);	
								
								value = sensor.compute(flag);
							} else if (idDevice == _SENSOR_COLORRGB) {
								var sensor = new sensorRGBColor();
								sensor.set([params[nbVar-2], params[nbVar-3], params[nbVar-1]]);	
								value = sensor.compute(flag);
							} else {
								value =  idDevice;
							}
							break;
						}
						//------------------
					}
					if (type<=6) 
					{
						responseValue(extId,value);
					}else{
						responseValue();
					}
					_rxBuf = [];
				}
			} 
		}
    }

	function readFloat(arr, position) {
		var f= [arr[position],arr[position+1],arr[position+2],arr[position+3]];
		return parseFloat(f);
	}
	function readShort(arr, position) {
		var s= [arr[position],arr[position+1]];
		return parseShort(s);
	}
	function readInt(arr,position,count){
		var result = 0;
		for(var i=0; i<count; ++i){
			result |= arr[position+i] << (i << 3);
		}
		return result;
	}
	function readDouble(arr ,position) {
		return readFloat(arr,position);
	}
	function readString(arr, position, len) {
		var value = "";
		for(var ii=0;ii<len;ii++){
			value += String.fromCharCode(_rxBuf[ii+position]);
		}
		return value;
	}
    function appendBuffer( buffer1, buffer2 ) {
        return buffer1.concat( buffer2 );
    }

    // Extension API interactions
    var potentialDevices = [];
    ext._deviceConnected = function(dev) {
        potentialDevices.push(dev);

        if (!device) {
            tryNextDevice();
        }
    }

    function tryNextDevice() {
        // If potentialDevices is empty, device will be undefined.
        // That will get us back here next time a device is connected.
        device = potentialDevices.shift();
        if (device) {
            device.open({ stopBits: 0, bitRate: 115200, ctsFlowControl: 0 }, deviceOpened);
        }
    }

    function deviceOpened(dev) {
        if (!dev) {
            // Opening the port failed.
            tryNextDevice();
            return;
        }
        device.set_receive_handler('ts',function(data) {
            processData(data);
        });
    };

    ext._deviceRemoved = function(dev) {
        if(device != dev) return;
        device = null;
    };

    ext._shutdown = function() {
        if(device) device.close();
        device = null;
    };

    ext._getStatus = function() {
        if(!device) return {status: 1, msg: 'demo disconnected'};
        return {status: 2, msg: 'demo connected'};
    }

    var descriptor = {};
	ScratchExtensions.register('ts', descriptor, ext, {type: 'serial'});
})({});
