#include <Arduino.h>
#include "KD-CLASS-3.h"
#include "SeeedOLED.h"
#include "IRSendRev.h"
#include "Seeed_BMP280.h"

float getTemp(int analogValue){
    float R = 1023.0 / analogValue - 1.0;
    R = R0*R;
    float temperature = 1.0/(log(R/R0)/B+1/298.15)-273.15;  // convert to temperature via datasheet
    return temperature ; 
}

void changeOledContrast(bool contrastMode){
  if(contrastMode){
    SeeedOled.setNormalDisplay();
  }else{
    SeeedOled.setInverseDisplay();
  }
}

void OledScroll(bool dir, int start, int end, int speed){
  unsigned char scrollSpeed ;
  unsigned char direction ;
  if(dir){
    direction= Scroll_Right ; 
  }else{
    direction = Scroll_Left ;
  }
  switch(speed){
    case 8:
      scrollSpeed = Scroll_2Frames; // Scroll_XFrames are "#define" parts from SeeedOLED library
      break;
    case 7:
      scrollSpeed = Scroll_3Frames;
      break;
    case 6:
      scrollSpeed = Scroll_4Frames;
      break;
    case 5:
      scrollSpeed = Scroll_5Frames;
      break;
    case 4:
      scrollSpeed = Scroll_25Frames;
      break;
    case 3:
      scrollSpeed = Scroll_64Frames;
      break;
    case 2:
      scrollSpeed = Scroll_128Frames;
      break;
    default:
      scrollSpeed = Scroll_256Frames;
      break;
  }
  SeeedOled.setHorizontalScrollProperties(direction,start,end,scrollSpeed);
  SeeedOled.activateScroll(); 
}

void OledPutString(String text, int line, int column){
  if (scrollState)SeeedOled.deactivateScroll();
  SeeedOled.setTextXY(line,column);
  SeeedOled.putString("                ");
  SeeedOled.setTextXY(line,column);
  SeeedOled.putString(text);
  if (scrollState)SeeedOled.activateScroll();
}

void OledPutNumber(long number, int line, int column){
  if (scrollState)SeeedOled.deactivateScroll();
  SeeedOled.setTextXY(line,column);
  SeeedOled.putString("                ");
  SeeedOled.setTextXY(line,column);
  SeeedOled.putNumber(number);
  if (scrollState)SeeedOled.activateScroll();
}

String bluetoothChangeDeviceName(String name){
  return "AT+NAME" + name ;
}

String bluetoothChangePinCode(int a, int b, int c, int d){
  String string = "AT+PIN" ;
  string += a ;
  string += b ;
  string += c ;
  string += d ;
  return string;
}

int speedLeft = 70;
int speedRight = 70;
int memDir = 9;

int changeMotorsDirectionLeft(int dir){
  int Left;
  memDir = dir;
  if((dir == 1) || (dir == 2) || (dir == 3)){
    Left = 90 + speedLeft;
  }else if((dir == 4) || (dir == 5) || (dir == 7)){
    Left = 90 - speedLeft;
  }else if((dir == 6) || (dir == 8) || (dir == 9)){
    Left = 90;
  }
  return Left; 
}

int changeMotorsDirectionRight(int dir){
  int Right;
  memDir = dir;
  if((dir == 3) || (dir == 5) || (dir == 6)){
    Right = 90 + speedRight;
  }else if((dir == 1) || (dir == 7) || (dir == 8)){
    Right = 90 - speedRight;
  }else if((dir == 2) || (dir == 4) || (dir == 9)){
    Right = 90;
  }
  return Right;
}

int setSpeed(int speedPourcent, int selecMode, int mot){
  if (speedPourcent > 100) speedPourcent = 100;
  else if (speedPourcent < 0) speedPourcent = 0;
  speedPourcent = speedPourcent/2.5;
  if(selecMode == 1){
    speedRight = speedPourcent;
  }else if(selecMode == 1){
    speedLeft = speedPourcent;
  }else{
    speedRight = speedPourcent;
    speedLeft = speedPourcent;
  }
  if(mot == 1) return changeMotorsDirectionRight(memDir); //Right
  else return changeMotorsDirectionLeft(memDir); //Left
}

int IrGetCode(){
  unsigned char dta[20];
  if(IR.IsDta()){
    IR.Recv(dta); 
  }
  return dta[6];
}

void IrSendData(int data){
  unsigned char dtaSend[20]={6,179,90,11,33,1,data};
  IR.Send(dtaSend, 38);
}

float getBarometerData(int dataSelec){
  switch(dataSelec){
    case 1:
      return float(bmp280.getPressure());
      break;
    case 2:
      return float(bmp280.calcAltitude(bmp280.getPressure()));
      break;
    case 3:
      return float(bmp280.getTemperature());
      break;
  }
}
